-- Use this file as template. Do not modify this file for running some testcases

outputname = 'plate'
outputpreview = true 

cubeLength = 4.0

--debug = { debugMode = true, debugMesh = 'debug/' }

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {
                 origin = {cubeLength/(-2.0),cubeLength/(-2.0),cubeLength/(-2.0)},
                 length = cubeLength
                }

minlevel = 4
-- the level of the slip walls (has to be the same as the min level)
geom_level = minlevel

-- the refinement level of the plate
plate_level = minlevel+4

-- smallness parameter
eps = bounding_cube.length/(2^(plate_level+5))

-- the element size around the plate
smalleps = bounding_cube.length/(2^plate_level)

-- the element size of the largest elements (belonging to minlevel)
largeeps = bounding_cube.length/(2^geom_level)

spatial_object = 
                {
                  -- eastern inflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'inflowEast',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                     (-1)*bounding_cube.length/2+largeeps,
                                                     (-1)*bounding_cube.length/2+eps,
                                                     (-1)*bounding_cube.length/2+eps,
                                                  },
                                          },
                              }
                  },
                  -- western outflow bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'outflowWest',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {0.0,bounding_cube.length,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                   bounding_cube.length/2-largeeps, 
                                                   -bounding_cube.length/2+eps, 
                                                   -bounding_cube.length/2+eps, 
                                                  },
                                          },
                              }
                  },
                  -- southern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipSouth',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                    -bounding_cube.length/2+eps,
                                                    -bounding_cube.length/2+largeeps,
                                                    -- -eps,
                                                    -bounding_cube.length/2+eps
                                                  },
                                          },
                              }
                  },
                  -- northern slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipNorth',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,0.0,bounding_cube.length},
                                                },
                                           origin={
                                                    -bounding_cube.length/2+eps,
                                                    bounding_cube.length/2-largeeps,
                                                   -- largeeps+eps,
                                                    -bounding_cube.length/2+eps
                                                  },
                                          },
                              }
                  },
                  -- bottom slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipBottom',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,bounding_cube.length,0.0},
                                                },
                                           origin={
                                                    -bounding_cube.length/2+eps,
                                                    -bounding_cube.length/2+eps,
                                                    -bounding_cube.length/2+largeeps,
                                                    -- -eps
                                                  },
                                          },
                              }
                  },
                  -- top slip bnd
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'slipTop',
                                 level = geom_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {bounding_cube.length,0.0,0.0},
                                                  {0.0,bounding_cube.length,0.0},
                                                },
                                           origin={
                                                    -bounding_cube.length/2+eps,
                                                    -bounding_cube.length/2+eps,
                                                    bounding_cube.length/2-largeeps,
                                                    -- largeeps+eps
                                                  },
                                          },
                              }
                  },
                  -- the plate in the middle
                  {
                   attribute = {
                                 kind = 'boundary',
                                 label = 'plate',
                                 level = plate_level,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {2*smalleps-2*eps,0.0,0.0},
                                                  {0.0,20*smalleps-2*eps,0.0},
                                                  {0.0,0.0,20*smalleps-2*eps},--bounding_cube.length},
                                                },
                                           origin={
                                                    -4*largeeps+eps,
                                                    -10*smalleps+eps,
                                                    -10*smalleps+eps,
                                                 --   -2*largeeps--(1+plate_level)*smalleps+eps,
                                                    --(1+plate_level)*smalleps+eps, --(-1.0)*bounding_cube.length/2.0
                                                ---largeeps/2.0+eps-smalleps, --(1+plate_level)*smalleps+eps,
                                                ---largeeps/2.0+eps-smalleps, --(1+plate_level)*smalleps+eps, --(-1.0)*bounding_cube.length/2.0
                                                  },
                                          },
                              }
                  },
                  -- refinebox for the source term
                  {
                   attribute = {
                                 kind = 'refinement',
                                 level = plate_level+0,
                               },
                   geometry = {
                                 kind = 'canoND',
                                 object = 
                                          {
                                           vec= {
                                                  {-2*smalleps,0.0,0.0},  -- {smalleps-2*eps+2*eps,0.0,0.0},
                                                  {0.0,2*smalleps-2*eps,0.0},-- {0.0,3*smalleps-2*eps,0.0},
                                                  {0.0, 0.0,2*smalleps-2*eps},-- {0.0,0.0,3*smalleps-2*eps},--largeeps-2*eps},
                                                },
                                           origin={
                                                   smalleps+eps,
                                                   --3*largeeps+eps,
                                                   -smalleps+eps,
                                                   -smalleps+eps,
                                                   -- -3*smalleps+eps,
                                                   -- -3*smalleps+eps,
                                                  },
                                          },
                              }
                  },
                  -- seed 
                  {
                  attribute = {
                               kind = 'seed'
                              },
                  geometry = {
                               kind = 'canoND',
                               object =  
                                        {
                                           origin = {eps,eps,eps},

                                        },
                             },
                  },
                }
	    
