-- Configuration file for Ateles (Constant State for acoustic equations) --

-- This configuration is the most simple test, to find a bug in the
-- acoustic implementation.
--
-- For a constant initial condition with non-zero density, we get
-- variations in the non-x modes of the velocities after the first
-- iteration.
-- The integral mean seems to be maintained.
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
-- Parameters to vary --
degree = 1
poly_space = 'Q'

-- Check for Nans and unphysical values
check =  { interval = 1 }

-- ...the general projection table
-- No projections should be needed in this case.
projection = {
              -- kind = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
              -- for fpt the  nodes are automatically 'chebyshev'
              -- for lep the  nodes are automatically 'gauss-legendre'
           -- lobattopoints = false  -- if lobatto points should be used, default = false,
                                     -- only working for chebyshev points --> fpt
              factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
           -- blocksize = 32,        -- for fpt, default -1
           -- fftmultithread = false -- for fpt, logical, default false
             }

--...Configuration of simulation time
-- The error we are looking for already gets appearant with in a single
-- iteration.
sim_control = { 
                time_control = { max = {iter = 100},  -- final Simulated time
                                 min = 0,
                                 interval = {iter = 100} 
                                }
              }

-- End  Parameters to vary --
--------------------------------------------------------------------------------
-- Definition of the test-case.

-- Mesh definitions --
-- ...the uniform refinement level for the periodic cube
level = 0
-- ...the length of the cube
cubeLength = 2.0

mesh = { predefined = 'line',
         origin = { 0.0 },
         length = cubeLength,
         refinementLevel = level
       }

-- Tracking              
halfwidth = cubeLength/math.pow(2,level+1)
tracking = {
             label = 'track_state',
             folder = './', --'./tracking/level0_p1/',
             variable = {'density', 'velocity'},
             shape = {kind = 'canoND', object= { origin = {halfwidth,halfwidth,halfwidth} } },
             time_control= { min = 0, interval = {iter = 1}},
             format = 'ascii',
           }


-- Global simulation options
simulation = {
              name = 'const'..poly_space..(degree+1), -- the name of the simulation
              time = simtime
             }

-- Equation definitions --
equation = {
             name   = 'acoustic',
             background = {
                 density = 1, 
                 velocityX = 0.0,
                 velocityY = 0.0,
                 velocityZ = 0.0,
                 pressure = 1
                 }
           }

-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'modg',            -- we use the modal discontinuous Galerkin scheme 
               m =  degree,                   -- the maximal polynomial degree for each spatial direction
               modg_space = poly_space
               }, 
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitEuler',
              -- 'explicitRungeKutta', 
              -- steps = 4,
               -- how to control the timestep
               control = {
                          name = 'cfl',   -- the name of the timestep control mechanism
                          cfl  = 0.8,     -- CourantÐFriedrichsÐLewy number
                         },
               },
             }

-- Initial Condition definitions --
initial_condition = { 
                      density = 0.004, 
                      velocityX = 0.001,
                      velocityY = 0.0,
                      velocityZ = 0.0,
                    }

--...Configuration for the restart file
restart = { 
--            -- file to restart from
--            read = './restart/maxwell/per_osci_maxwell_modg_lastHeader.lua',                        
--            -- folder to write restart data to
            write = 'restart/level0_p1/',
            -- temporal definition of restart write
            time_control= { min = 0, interval = {iter = 100} },
          }
