-- Configuration file for Ateles (Periodic Oscillator) --

-- This is a configuration file for the Finite Volume / Discontinuous Galerkin Solver ATELES. 
-- It provides a testcase for the simulation of Acoustic equations in a homogenous media. The simulation domain
-- is a periodic cube with edge length 2.0. Therefore this is a very good way to verify your algorithmic implementations, 
-- since this testcase does not involve any boundary conditions. 
-- The testcase simulates the temporal development of standing waves for acoustic equation. Since we 
-- are considering a very simple domain, an analytic solution is well known and given as Lua functions in this script.
-- Therefore we suggest this testcase to verify one of the following topics
-- ... algorihtmic correctness
-- ... spatial and temporal order of your scheme
-- ... diffusion and dispersion relations of your scheme
-- ... and many more.
-- To verify diffusion and dispersion relations this testcases allows you to modify the spatial harmonics by
-- varying the integer mode number in x and y direction by modifying the lua variables m and n.
-- This testcase can be run in serial (only one execution unit) or in parallel (with multiple mpi ranks).
-- To calculate a grid convergence behavior please modify the level variable. An increment of one will half the radius of your elements.

--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
-- Parameters to vary --
degree = 1
poly_space = 'Q'

-- Check for Nans and unphysical values
check =  {
           interval = 100,

         }

-- ...the general projection table
projection = {
              kind = 'fpt',  -- 'fpt' or 'l2p', default 'l2p'
              -- for fpt the  nodes are automatically 'chebyshev'
              -- for lep the  nodes are automatically 'gauss-legendre'
           -- lobattopoints = false  -- if lobatto points should be used, default = false,
                                     -- only working for chebyshev points --> fpt
              factor = 1.0,          -- dealising factpr for fpt, oversampling factor for l2p, float, default 1.0
           -- blocksize = 32,        -- for fpt, default -1
           -- fftmultithread = false -- for fpt, logical, default false
             }

--...Configuration of simulation time
sim_control = { 
                time_control = { max = {iter = 100},  -- final Simulated time
                                 min = 0,
                                 interval = {iter = 100} 
                                }
              }

-- End  Parameters to vary --
--------------------------------------------------------------------------------
-- Definition of the test-case.

-- Mesh definitions --
-- ...the uniform refinement level for the periodic cube
level = 0
-- ...the length of the cube
cubeLength = 2.0
mesh = { predefined = 'line',
         origin = { 
                    (-1.0)*cubeLength/2.0,
                    (-1.0)*cubeLength/2.0,
                    (-1.0)*cubeLength/2.0
                  },
         length = cubeLength,
         refinementLevel = level
       }

-- Tracking              
eps=cubeLength/math.pow(2,level+1)
tracking = {
             label = 'track_line_density',
             folder = './',--'./tracking/level10_p2/',
             variable = {'velocity'},
             shape = {kind = 'canoND', object= { origin = {-1.0+eps,0.0,0.0}, 
                                                -- vec = { {cubeLength-eps,0.0,0.0}},
                                                --  segments = {1000},
                                                --  distribution='equal'
                                                }
             },
             time_control= { min = 0,
                            -- max = sim_control.time_control.max,
                            interval = {iter = 1}--sim_control.time_control.max/2.0,
                    },
             format = 'ascii',
           }


-- Global simulation options
simulation = {
              name = 'plane_wave_X'..poly_space..(degree+1),            -- the name of the simualtion
              time = simtime
             }

-- Equation definitions --
equation = {
             name   = 'acoustic',
             background = {
                 density = 1.225, 
                 velocityX = 0.0,
                 velocityY = 0.0,
                 velocityZ = 0.0,
                 pressure = 100000.0
                 }
           }

-- Scheme definitions --
scheme = {
    -- the spatial discretization scheme
    spatial =  {
               name = 'modg',            -- we use the modal discontinuous Galerkin scheme 
               m =  degree,                   -- the maximal polynomial degree for each spatial direction
               modg_space = poly_space
               }, 
    -- the temporal discretization scheme
    temporal = {
               name = 'explicitEuler',
              -- 'explicitRungeKutta', 
              -- steps = 4,
               -- how to control the timestep
               control = {
                          name = 'cfl',   -- the name of the timestep control mechanism
                          cfl  = 0.8,     -- CourantÐFriedrichsÐLewy number
                         },
               },
             }

-- Initial Condition definitions --
initial_condition = { 
                      density = 0.004, 
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0,
                    }

--...Configuration for the restart file
restart = { 
--            -- file to restart from
--            read = './restart/maxwell/per_osci_maxwell_modg_lastHeader.lua',                        
--            -- folder to write restart data to
            write = 'restart/level0_p1/',
            -- temporal definition of restart write
            time_control= { min = 0,
                            interval = {iter = 1} ,
                         },
          }
