######################################################################
# ref_path and output have to be provided as a string
#
# Execute shepherd like this: ./shepherd.py ateles_params.py
#
#####################################################################
import os
import sys
import datetime
import shutil

from clone_and_build_function import *

# Set this switch to true to abort the recheck when the first job fails.
abort = False

templateFolder = './templates/'
machineFolder = './machines/'
apesFolder = os.getenv('HOME')+'/apes/'

date = datetime.datetime.now().strftime("%Y-%m-%d__%X")
weekday = datetime.datetime.now().strftime("%A")

# Production directory, keep the past week as history.
prod_dir = 'ateles-runs_' + weekday

run_label = 'ATELES'

# Cleanup production directory before using it:
shutil.rmtree(prod_dir, ignore_errors=True)
loglevel = 'INFO'

# source for the mercurial functions
hg_clone_source = 'ssh://geb.sts.nt.uni-siegen.de//var/www/repos/hg/'

# mail adress
from recheck import notify_list
mail_address = notify_list

# name of the shepherd log file
shepherd_out = 'shepherd.log'

# name of the log and rror file of the clone and build function
clone_build_out = 'clone_build.log'
clone_build_err = 'clone_build_error.log'

# Set this to true to have the current revision marked as working when all tests
# succeed.
create_tag_on = True
# Set this to true to have shepherd store the performance results in the loris
# repository.
grep_performance = True

loris_clone_url = apesFolder + 'loris/'

# path to the testsuite dir to shorten the string in the job_dict
atldir = apesFolder + 'ateles/testsuite/'
fluiddir     = atldir + 'fluid/'
acousticdir  = atldir + 'acoustic/'
linearEulerdir  = atldir + 'linear_euler/'
eddir        = atldir + 'electrodynamic/'
verdir       = atldir + 'verification/'


loris_clone_url = apesFolder + 'loris/'


shepherd_jobs = []

seeder_exe = clone_build( solver          = 'seeder',
                          revision        = 'default',
                          hg_clone_source = hg_clone_source+'seeder',
                          solver_dir      = 'seeder',
                          clone_build_out = clone_build_out,
                          clone_build_err = clone_build_err         )

ateles_exe = clone_build( solver          = 'ateles',
                          hg_clone_source = hg_clone_source+'ateles',
                          solver_dir      = 'ateles',
                          clone_build_out = clone_build_out,
                          clone_build_err = clone_build_err         )

### ATELES JOB 1
shepherd_jobs.append(
    dict(
        executable = None,
        mail = False,
        template = fluiddir + 'shear-layer/hyperfun.lua',
        extension = 'lua',
        run_exec = False,
        abort_failure = abort,
        prefix = 'shearlayer_modg_Q4_valid',
        label = 'shearlayer_modg_Q4_valid_hyperfun',
    )
)
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = fluiddir + 'shear-layer/seeder.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        depend = ['shearlayer_modg_Q4_valid_hyperfun'],
        label = 'shearlayer_modg_Q4_valid_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'shear-layer/ateles_modg_Q4.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['shearlayer_modg_Q4_valid_seeder'],
        label = 'shearlayer_modg_Q4_valid_ateles',
        attachment = True,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'shear-layer/ref_shear_layer_modg_probe_momentum_Q4_p00000.res',
        val_output_filename = 'shear_layer_modg_probe_momentum_Q4_p00000.res',
    )
)

### ATELES JOB 2
shepherd_jobs.append(
    dict(
        executable = None,
        mail = False,
        template = fluiddir + 'shear-layer/hyperfun.lua',
        extension = 'lua',
        run_exec = False,
        abort_failure = abort,
        prefix = 'shearlayer_modg_Q8_valid',
        label = 'shearlayer_modg_Q8_valid_hyperfun',
    )
)
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = fluiddir + 'shear-layer/seeder.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        depend = ['shearlayer_modg_Q8_valid_hyperfun'],
        label = 'shearlayer_modg_Q8_valid_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'shear-layer/ateles_modg_Q8.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['shearlayer_modg_Q8_valid_seeder'],
        label = 'shearlayer_modg_Q8_valid_ateles',
        attachment = True,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'shear-layer/ref_shear_layer_modg_probe_momentum_Q8_p00000.res',
        val_output_filename = 'shear_layer_modg_probe_momentum_Q8_p00000.res',
    )
)

### ATELES JOB 3
shepherd_jobs.append(
    dict(
        executable = None,
        mail = False,
        template = fluiddir + 'shear-layer/hyperfun.lua',
        extension = 'lua',
        run_exec = False,
        abort_failure = abort,
        prefix = 'parallel_shearlayer_modg_Q4_valid',
        label = 'parallel_shearlayer_modg_Q4_valid_hyperfun',
    )
)
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = fluiddir + 'shear-layer/seeder.lua',
        extension = 'lua',
        run_exec = True,
        create_subdir = ['mesh'],
        abort_failure = abort,
        depend = ['parallel_shearlayer_modg_Q4_valid_hyperfun'],
        label = 'parallel_shearlayer_modg_Q4_valid_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'shear-layer/ateles_modg_Q4.lua',
        extension = 'lua',
        run_exec = True,
        run_command = 'mpirun -np 2',
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['parallel_shearlayer_modg_Q4_valid_seeder'],
        label = 'parallel_shearlayer_modg_Q4_valid_ateles',
        attachment = True,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'shear-layer/ref_shear_layer_modg_probe_momentum_Q4_p00000.res',
        val_output_filename = 'shear_layer_modg_probe_momentum_Q4_p00000.res'
    )
)

### ATELES JOB 4
shepherd_jobs.append(
    dict(
        executable = None,
        mail = False,
        template = eddir + 'periodic_oscillator/maxwell/modg/posci_common.lua',
        extension = 'lua',
        run_exec = False,
        abort_failure = abort,
        prefix = 'posci_modg_Q8_valid',
        label = 'posci_modg_Q8_valid_common',
    )
)
shepherd_jobs.append(
    dict(
        executable = None,
        mail = False,
        template = eddir + 'periodic_oscillator/maxwell/modg/valid_tracking.lua',
        extension = 'lua',
        run_exec = False,
        abort_failure = abort,
        label = 'posci_modg_Q8_valid_tracking',
        depend = ['posci_modg_Q8_valid_common'],
    )
)
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = eddir + 'periodic_oscillator/maxwell/modg/seeder_source.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        label = 'posci_modg_Q8_valid_seeder',
        depend = ['posci_modg_Q8_valid_tracking'],
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = eddir + 'periodic_oscillator/maxwell/modg/ateles_Q8_valid.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        label = 'posci_modg_Q8_valid_ateles',
        depend = ['posci_modg_Q8_valid_seeder'],
        attachment = True,
        validation = True,
        val_method = 'difference',
        val_ref_path = eddir + 'periodic_oscillator/maxwell/modg/ref_posci_modgQ8_probe_electricField_Q8_p00000.res',
        val_output_filename = 'posci_modgQ8_probe_electricField_Q8_p00000.res',
    )
)

### ATELES JOB 5
shepherd_jobs.append(
    dict(
        executable = None,
        mail = False,
        template = eddir + 'periodic_oscillator/maxwell/modg/posci_common.lua',
        extension = 'lua',
        run_exec = False,
        abort_failure = abort,
        prefix = 'parallel_posci_modg_Q8_valid',
        label = 'parallel_posci_modg_Q8_valid_common',
    )
)
shepherd_jobs.append(
    dict(
        executable = None,
        mail = False,
        template = eddir + 'periodic_oscillator/maxwell/modg/valid_tracking.lua',
        extension = 'lua',
        run_exec = False,
        abort_failure = abort,
        label = 'parallel_posci_modg_Q8_valid_tracking',
        depend = ['parallel_posci_modg_Q8_valid_common'],
    )
)
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = eddir + 'periodic_oscillator/maxwell/modg/seeder_source.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        depend = ['parallel_posci_modg_Q8_valid_tracking'],
        label = 'parallel_posci_modg_Q8_valid_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = eddir + 'periodic_oscillator/maxwell/modg/ateles_Q8_valid.lua',
        extension = 'lua',
        run_exec = True,
        run_command = 'mpirun -np 2',
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['parallel_posci_modg_Q8_valid_seeder'],
        label = 'parallel_posci_modg_Q8_valid_ateles',
        attachment = True,
        validation = True,
        val_method = 'difference',
        val_ref_path = eddir + 'periodic_oscillator/maxwell/modg/ref_posci_modgQ8_probe_electricField_Q8_p00000.res',
        val_output_filename = 'posci_modgQ8_probe_electricField_Q8_p00000.res',
    )
)

### ATELES JOB 6
shepherd_jobs.append(
    dict(
        executable = None,
        mail = False,
        template = eddir + 'periodic_oscillator/maxwell/modg/posci_common.lua',
        extension = 'lua',
        run_exec = False,
        abort_failure = abort,
        prefix = 'posci_modg_P8_valid',
        label = 'posci_modg_P8_valid_common',
    )
)
shepherd_jobs.append(
    dict(
        executable = None,
        mail = False,
        template = eddir + 'periodic_oscillator/maxwell/modg/valid_tracking.lua',
        extension = 'lua',
        run_exec = False,
        abort_failure = abort,
        label = 'posci_modg_P8_valid_tracking',
        depend = ['posci_modg_P8_valid_common'],
    )
)
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = eddir + 'periodic_oscillator/maxwell/modg/seeder_source.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        depend = ['posci_modg_P8_valid_tracking'],
        label = 'posci_modg_P8_valid_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = eddir + 'periodic_oscillator/maxwell/modg/ateles_P8_valid.lua',
        extension='lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['posci_modg_P8_valid_seeder'],
        create_depend_path = True,
        label = 'posci_modg_P8_valid_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = eddir + 'periodic_oscillator/maxwell/modg/ref_posci_modgP8_probe_electricField_P8_p00000.res',
        val_output_filename = 'posci_modgP8_probe_electricField_P8_p00000.res',
    )
)

### ATELES JOB 7
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = eddir + 'rectangular_wave_guide/maxwell/finiteVolume/seeder.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        prefix = 'rectwaveguid_modg_Q8',
        label = 'rectwaveguid_modg_Q8_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = eddir + 'rectangular_wave_guide/maxwell/finiteVolume/ateles_maxwell_modg_valid.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['rectwaveguid_modg_Q8_seeder'],
        label = 'rectwaveguid_modg_Q8_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = eddir + 'rectangular_wave_guide/maxwell/finiteVolume/ref_rectang_waveguide_maxwell_modg_probe_electricField_Q8_p00000.res',
        val_output_filename = 'rectang_waveguide_maxwell_modg_probe_electricField_Q8_p00000.res',
    )
)

### ATELES JOB 8
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = eddir + 'pec_scatter_inhomogenous_material/seeder.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        prefix = 'pecScat_inhomMat_modg_Q8',
        label = 'pecScat_inhomMat_modg_Q8_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = eddir + 'pec_scatter_inhomogenous_material/ateles_maxwell_modg.lua',
        extension = 'lua',
        run_exec = True,
        run_command = 'mpirun -np 4',
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['pecScat_inhomMat_modg_Q8_seeder'],
        label = 'pecScat_inhomMat_modg_Q8_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = eddir + 'pec_scatter_inhomogenous_material/ref_pec_scatter_maxwell_modg_probe_displacementField_Q8_p00000.res',
        val_output_filename = 'pec_scatter_maxwell_modg_probe_displacementField_Q8_p00000.res',
    )
)

### ATELES JOB 9
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = eddir + 'pec_scatter_inhomogenous_material/seeder.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        prefix = 'pecScat_inhomMatFunc_modg_Q8',
        label = 'pecScat_inhomMatFunc_modg_Q8_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = eddir + 'pec_scatter_inhomogenous_material/ateles_matFunc_maxwell_modg.lua',
        extension = 'lua',
        run_exec = True,
        run_command = 'mpirun -np 4',
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['pecScat_inhomMatFunc_modg_Q8_seeder'],
        label = 'pecScat_inhomMatFunc_modg_Q8_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = eddir + 'pec_scatter_inhomogenous_material/ref_pec_scatter_maxwell_modg_probe_displacementField_Q8_p00000.res',
        val_output_filename = 'pec_scatter_maxwell_modg_probe_displacementField_Q8_p00000.res',
    )
)

### ATELES JOB 10
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = fluiddir + 'toro_series/toro_1/xdir/seeder.lua',
        extension='lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        prefix = 'toro1_x_modg_Q4',
        label = 'toro1_x_modg_Q4_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'toro_series/toro_1/xdir/ateles_toro1_x_modg_3d.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['toro1_x_modg_Q4_seeder'],
        label = 'toro1_x_modg_Q4_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'toro_series/toro_1/xdir/ref_toro1_x_euler_modg_probe_density_Q4_toro_x_p00000.res',
        val_output_filename = 'toro1_x_euler_modg_probe_density_Q4_toro_x_p00000.res',
    )
)

### ATELES JOB 11
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = fluiddir + 'toro_series/toro_1/ydir/seeder.lua' ,
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        prefix = 'toro1_y_modg_Q4',
        label = 'toro1_y_modg_Q4_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'toro_series/toro_1/ydir/ateles_toro1_y_modg_3d.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['toro1_y_modg_Q4_seeder'],
        label = 'toro1_y_modg_Q4_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'toro_series/toro_1/ydir/ref_toro1_y_euler_modg_probe_density_Q4_toro_y_p00000.res',
        val_output_filename = 'toro1_y_euler_modg_probe_density_Q4_toro_y_p00000.res',
    )
)

### ATELES JOB 12
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = fluiddir + 'toro_series/toro_1/zdir/seeder.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        prefix = 'toro1_z_modg_Q4',
        label = 'toro1_z_modg_Q4_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'toro_series/toro_1/zdir/ateles_toro1_z_modg_3d.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['toro1_z_modg_Q4_seeder'],
        label = 'toro1_z_modg_Q4_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'toro_series/toro_1/zdir/ref_toro1_z_euler_modg_probe_density_Q4_toro_z_p00000.res',
        val_output_filename = 'toro1_z_euler_modg_probe_density_Q4_toro_z_p00000.res',
    )
)

### ATELES JOB 13
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = fluiddir + 'toro_series/toro_1/xdir/seeder.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        prefix = 'toro1_x_modg_Q4_1d',
        label = 'toro1_x_modg_Q4_1d_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'toro_series/toro_1/xdir/ateles_toro1_x_modg_1d.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['toro1_x_modg_Q4_1d_seeder'],
        label = 'toro1_x_modg_Q4_1d_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'toro_series/toro_1/xdir/ref_toro1_x_euler_modg_1d_probe_density_Q4_toro_x_p00000.res',
        val_output_filename = 'toro1_x_euler_modg_1d_probe_density_Q4_toro_x_p00000.res',
    )
)

### ATELES JOB 14
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = fluiddir + 'toro_series/toro_1/xdir/seeder.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        prefix = 'toro1_x_modg_Q4_2d',
        label = 'toro1_x_modg_Q4_2d_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'toro_series/toro_1/xdir/ateles_toro1_x_modg_2d.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['toro1_x_modg_Q4_2d_seeder'],
        label = 'toro1_x_modg_Q4_2d_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'toro_series/toro_1/xdir/ref_toro1_x_euler_modg_2d_probe_density_Q4_toro_x_p00000.res',
        val_output_filename = 'toro1_x_euler_modg_2d_probe_density_Q4_toro_x_p00000.res',
    )
)

### ATELES JOB 15
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = fluiddir + 'toro_series/toro_1/ydir/seeder.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        prefix = 'toro1_y_modg_Q4_2d',
        label = 'toro1_y_modg_Q4_2d_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'toro_series/toro_1/ydir/ateles_toro1_y_modg_2d.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['toro1_y_modg_Q4_2d_seeder'],
        label = 'toro1_y_modg_Q4_2d_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'toro_series/toro_1/ydir/ref_toro1_y_euler_modg_2d_probe_density_Q4_toro_y_p00000.res',
        val_output_filename = 'toro1_y_euler_modg_2d_probe_density_Q4_toro_y_p00000.res',
    )
)

### ATELES JOB 16
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = fluiddir + 'toro_series/toro_2/seeder.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        prefix = 'toro2_modg_Q1_2d_SSPRK2',
        label = 'toro2_modg_Q1_2d_SSPRK2_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'toro_series/toro_2/ateles_toro2_x_modg_2d.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['toro2_modg_Q1_2d_SSPRK2_seeder'],
        label = 'toro2_modg_Q1_2d_SSPRK2_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'toro_series/toro_2/ref_toro2_euler_modg_2d_probe_density_Q1_toro_p00000.res',
        val_output_filename = 'toro2_euler_modg_2d_probe_density_Q1_toro_p00000.res',
    )
)

### ATELES JOB 17
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = fluiddir + 'toro_series/toro_3/seeder.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        prefix = 'toro3_modg_Q1_2d',
        label = 'toro3_modg_Q1_2d_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'toro_series/toro_3/ateles_toro3_x_modg_2d.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['toro3_modg_Q1_2d_seeder'],
        label = 'toro3_modg_Q1_2d_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'toro_series/toro_3/ref_toro3_euler_modg_2d_probe_density_toro_p00000.res',
        val_output_filename = 'toro3_euler_modg_2d_probe_density_toro_p00000.res',
    )
)

### ATELES JOB 18
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'gauss_pulse/ateles_euler_l2p_recheck.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        prefix = 'gaussian_pulse_l2p',
        label = 'gaussian_pulse_l2p_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'gauss_pulse/ref_gPulseDens_euler_modg_track_momentum_l2p_p00000.res',
        val_output_filename = 'gPulseDens_euler_modg_track_momentum_l2p_p00000.res',
    )
)

### ATELES JOB 19
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'gauss_pulse/ateles_euler_fxt_recheck.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        prefix = 'gaussian_pulse_fxt',
        label = 'gaussian_pulse_fxt_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'gauss_pulse/ref_gPulseDens_euler_fxt_track_momentum_fxt_p00000.res',
        val_output_filename = 'gPulseDens_euler_fxt_track_momentum_fxt_p00000.res',
    )
)

### ATELES JOB 20
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'gauss_pulse/ateles_euler_modg_recheck.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        prefix = 'gaussian_pulse',
        label = 'gaussian_pulse_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'gauss_pulse/ref_gPulseDens_euler_modg_track_momentum_p00000.res',
        val_output_filename = 'gPulseDens_euler_modg_track_momentum_p00000.res',
    )
)

### ATELES JOB 21
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = fluiddir + 'toro_series/toro_4/seeder.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        prefix = 'toro4_modg_Q1_2d',
        label = 'toro4_modg_Q1_2d_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'toro_series/toro_4/ateles_toro4_x_modg_2d.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['toro4_modg_Q1_2d_seeder'],
        label = 'toro4_modg_Q1_2d_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'toro_series/toro_4/ref_toro4_euler_modg_2d_probe_density_toro_p00000.res',
        val_output_filename = 'toro4_euler_modg_2d_probe_density_toro_p00000.res',
    )
)

### ATELES JOB 22
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = eddir + 'periodic_oscillator/maxwell/modg/seeder_source.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        prefix = 'maxwell_DivCor',
        label = 'maxwell_DivCor_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = eddir + 'periodic_oscillator/maxwell/modg/ateles_divcor_p.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['maxwell_DivCor_seeder'],
        label = 'maxwell_DivCor_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = eddir + 'periodic_oscillator/maxwell/modg/ref_maxwell_divcor_probe_electricField_P8_p00000.res',
        val_output_filename = 'maxwell_divcor_probe_electricField_P8_p00000.res',
    )
)

### ATELES JOB 23
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = eddir + 'periodic_oscillator/maxwell/modg/seeder_source.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        prefix = 'maxwell_DivCor_source',
        label = 'maxwell_DivCor_source_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = eddir + 'periodic_oscillator/maxwell/modg/ateles_source_Q8_recheck.lua',
        extension = 'lua',
        run_exec = True,
        run_command = 'mpirun -np 8',
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['maxwell_DivCor_source_seeder'],
        label = 'maxwell_DivCor_source_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = eddir + 'periodic_oscillator/maxwell/modg/ref_maxwell_source_divcor_source_probe_electricField_Q8_p00000.res',
        val_output_filename = 'maxwell_source_divcor_source_probe_electricField_Q8_p00000.res',
    )
)

### ATELES JOB 24
shepherd_jobs.append(
    dict(
        executable = None,
        mail = False,
        template = eddir + 'pml/hyperfun.lua',
        extension = 'lua',
        run_exec = False,
        abort_failure = abort,
        prefix = 'maxwell_circlematerial_pml_source',
        label = 'maxwell_circlematerial_pml_source_hyperfun',
    )
)
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = eddir + 'pml/seeder.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        depend = ['maxwell_circlematerial_pml_source_hyperfun'],
        label = 'maxwell_circlematerial_pml_source_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = eddir + 'pml/ateles_recheck_Q8_maxwell_2d.lua',
        extension = 'lua',
        run_exec = True,
        run_command = 'mpirun -np 5',
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['maxwell_circlematerial_pml_source_seeder'],
        label = 'maxwell_circlematerial_pml_source_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = eddir + 'pml/ref_simulation_probe_electricField_Q8_pml_circMaterial_p00000.res',
        val_output_filename = 'simulation_probe_electricField_Q8_pml_circMaterial_p00000.res',
    )
)

### ATELES JOB 25
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = atldir + 'verification/derived_quantities/ateles_track_KE.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        prefix = 'euler_check_derVar',
        label = 'euler_check_derVar_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = atldir + 'verification/derived_quantities/ref_gPulseDens_euler_modg_track_ke_p00000.res',
        val_output_filename = 'gPulseDens_euler_modg_track_ke_p00000.res',
    )
)

### ATELES JOB 26
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'spongeLayer/ateles.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        prefix = 'spongeLayer',
        label = 'spongeLayer_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'spongeLayer/ref_sponge_layer_modg_sponge_p00000.res',
        val_output_filename = 'sponge_layer_modg_sponge_p00000.res',
    )
)

### ATELES JOB 27
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'viscous_vortex/ateles_nvrstk_modg_2d_recheck.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        prefix = 'viscousVortex_Q4_2d',
        label = 'viscousVortex_Q4_2d_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'viscous_vortex/ref_simulation_track_momentum_p00000.res',
        val_output_filename = 'simulation_track_momentum_p00000.res',
    )
)

### ATELES JOB 28
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = atldir + 'heat_equation/heat_3d/ateles.lua',
        extension='lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        prefix = 'Heat_3D',
        label = 'Heat_3D_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = atldir + 'heat_equation/heat_3d/ref_simulation_track_temp_p00000.res',
        val_output_filename = 'simulation_track_temp_p00000.res',
    )
)

### ATELES JOB 29
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = atldir + 'heat_equation/heat_2d/ateles_heat_2d.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        prefix = 'Heat_2D',
        label = 'Heat_2D_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = atldir + 'heat_equation/heat_2d/ref_simulation_track_temp_p00000.res',
        val_output_filename = 'simulation_track_temp_p00000.res',
    )
)

### ATELES JOB 30
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = atldir + 'heat_equation/heat_1d/ateles_heat_1d.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        prefix = 'Heat_1D',
        label = 'Heat_1D_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = atldir + 'heat_equation/heat_1d/ref_simulation_track_temp_p00000.res',
        val_output_filename = 'simulation_track_temp_p00000.res',
    )
)

### ATELES JOB 31
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'spongeLayer/ateles_sponge_2d.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        prefix = 'spongeLayer_2d',
        label = 'spongeLayer_2d_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'spongeLayer/ref_sponge_2d_modg_sponge_2d_p00000.res',
        val_output_filename = 'sponge_2d_modg_sponge_2d_p00000.res',
    )
)

### ATELES JOB 32
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'vorticity/ateles.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        prefix = 'vort',
        label = 'vort_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'vorticity/ref_vorticity_modg_vort_p00000.res',
        val_output_filename = 'vorticity_modg_vort_p00000.res',
    )
)

### ATELES JOB 33
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'vorticity/ateles_2d.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        prefix = 'vort_2d',
        label = 'vort_2d_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'vorticity/ref_vorticity_2d_modg_vort_p00000.res',
        val_output_filename = 'vorticity_2d_modg_vort_p00000.res',
    )
)

### ATELES JOB 34
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = acousticdir + 'planar_wave/ateles_recheck.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        prefix = 'acoustic_3d',
        label = 'acoustic_3d_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = acousticdir + 'planar_wave/ref_plane_wave_XQ8_track_line_density_m7_p00000.res',
        val_output_filename = 'plane_wave_XQ8_track_line_density_m7_p00000.res',
    )
)

### ATELES JOB 35
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = acousticdir + 'gauss_pulse/acoustic_modg_2d_recheck.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        prefix = 'acoustic_2d',
        label = 'acoustic_2d_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = acousticdir + 'gauss_pulse/ref_simulation_track_density_p00000.res',
        val_output_filename = 'simulation_track_density_p00000.res',
    )
)

### ATELES JOB 36
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = fluiddir + 'shock_stabilized/modg_3d/seeder.lua',
        extension='lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        prefix = 'covolume_modg_Q4_3d_rktaylor',
        label = 'covolume_modg_Q4_3d_rktaylor_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'shock_stabilized/modg_3d/ateles_recheck_Q4_covolume_3d.lua',
        extension = 'lua',
        run_exec = True,
        run_command = 'mpirun -np 2',
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['covolume_modg_Q4_3d_rktaylor_seeder'],
        label = 'covolume_modg_Q4_3d_rktaylor_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'shock_stabilized/modg_3d/ref_euler_3d_probe_density_Q4_covolume_rktaylor_z_p00000.res',
        val_output_filename = 'euler_3d_probe_density_Q4_covolume_rktaylor_z_p00000.res',
    )
)

### ATELES JOB 37
shepherd_jobs.append(
    dict(
        executable = None,
        mail = False,
        template = fluiddir + 'shock_stabilized/modg_3d_localRefinement/common_3d.lua',
        extension = 'lua',
        run_exec = False,
        abort_failure = abort,
        prefix = 'covolume_modg_3d_localrefinement_serial',
        label = 'covolume_modg_3d_localrefinement_serial_common3d',
    )
)
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = fluiddir + 'shock_stabilized/modg_3d_localRefinement/seeder.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        depend = ['covolume_modg_3d_localrefinement_serial_common3d'],
        label = 'covolume_modg_3d_localrefinement_serial_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'shock_stabilized/modg_3d_localRefinement/ateles_modg_3d.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['covolume_modg_3d_localrefinement_serial_seeder'],
        label = 'covolume_modg_3d_localrefinement_serial_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'shock_stabilized/modg_3d_localRefinement/ref_euler_3d_probe_density_covolume_multilevel_p00000.res',
        val_output_filename = 'euler_3d_probe_density_covolume_multilevel_p00000.res',
    )
)

### ATELES JOB 38
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = fluiddir + 'shock_stabilized/modg_3d_periodic/seeder.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        prefix = 'covolume_modg_3d_localrefinement_parallel',
        label = 'covolume_modg_3d_localrefinement_parallel_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'shock_stabilized/modg_3d_periodic/ateles_recheck_Q4_covolume_3d.lua',
        extension = 'lua',
        run_exec = True,
        run_command = 'mpirun -np 3',
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['covolume_modg_3d_localrefinement_parallel_seeder'],
        label = 'covolume_modg_3d_localrefinement_parallel_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'shock_stabilized/modg_3d_periodic/ref_euler_3d_probe_density_Q4_periodic_covolume_z_p00000.res',
        val_output_filename = 'euler_3d_probe_density_Q4_periodic_covolume_z_p00000.res',
    )
)

### ATELES JOB 39
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = fluiddir + 'shock_stabilized/modg_2d/seeder.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        prefix = 'covolume_modg_Q4_2d',
        label = 'covolume_modg_Q4_2d_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'shock_stabilized/modg_2d/ateles_recheck_Q4_2d.lua',
        extension = 'lua',
        run_exec = True,
        run_command = 'mpirun -np 2',
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['covolume_modg_Q4_2d_seeder'],
        label = 'covolume_modg_Q4_2d_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'shock_stabilized/modg_2d/ref_euler_2d_probe_density_Q4_covolume_rktaylor_y_p00000.res',
        val_output_filename = 'euler_2d_probe_density_Q4_covolume_rktaylor_y_p00000.res',
    )
)

### ATELES JOB 40
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = fluiddir + 'shock_stabilized/modg_1d/seeder.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        create_subdir = ['mesh'],
        prefix = 'covolume_modg_Q4_1d_rktaylor',
        label = 'covolume_modg_Q4_1d_rktaylor_seeder',
        mail = False,
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'shock_stabilized/modg_1d/ateles_recheck_Q4_1d_rktaylor.lua',
        extension = 'lua',
        run_exec = True,
        run_command = 'mpirun -np 2',
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['covolume_modg_Q4_1d_rktaylor_seeder'],
        label = 'covolume_modg_Q4_1d_rktaylor_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'shock_stabilized/modg_1d/ref_euler_1d_probe_density_Q4_covolume_rktaylor_x_p00000.res',
        val_output_filename = 'euler_1d_probe_density_Q4_covolume_rktaylor_x_p00000.res',
    )
)

### ATELES JOB 41
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = atldir + 'verification/derived_quantities/ateles_track_qCriterion.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        prefix = 'track_qCriterion_3d',
        label = 'track_qCriterion_3d_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = atldir + 'verification/derived_quantities/ref_q_crit_3d_vort_p00000.res',
        val_output_filename = 'q_crit_3d_vort_p00000.res',
    )
)

# ATELES JOB 42
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'constant_state/2D/ateles.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        prefix = 'track_NS_const_state',
        label =  'track_NS_const_state_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'constant_state/2D/ref_simulation_track_const_state_l2p_p00000.res',
        val_output_filename = 'simulation_track_const_state_l2p_p00000.res',
    )
)

### ATELES JOB 43
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = linearEulerdir + 'gauss_pulse/ateles_2d_recheck.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        prefix = 'linearEuler_2d',
        label =  'linearEuler_2d_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = linearEulerdir + 'gauss_pulse/ref_simulation_track_2d_density_p00000.res',
        val_output_filename = 'simulation_track_2d_density_p00000.res',
    )
)

### ATELES JOB 44
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = linearEulerdir + 'gauss_pulse/ateles_recheck.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        prefix = 'linearEuler_bc',
        label =  'linearEuler_bc_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = linearEulerdir + 'gauss_pulse/ref_simulation_track_density_p00000.res',
        val_output_filename = 'simulation_track_density_p00000.res',
    )
)

### ATELES JOB 45
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = linearEulerdir + 'gauss_pulse/ateles_temporalBackground_recheck.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        prefix = 'linearEuler_tempBackground',
        label =  'linearEuler_tempBackground_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = linearEulerdir + 'gauss_pulse/ref_simulation_track_density_temporalBackground_p00000.res',
        val_output_filename = 'simulation_track_density_temporalBackground_p00000.res',
    )
)

### ATELES JOB 45
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = linearEulerdir + 'gauss_pulse/ateles_2d_temporalBackground_recheck.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        prefix = 'linearEuler_2d_tempBackground',
        label =  'linearEuler_2d_tempBackground_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = linearEulerdir + 'gauss_pulse/ref_simulation_track_2d_density_temporalBackground_p00000.res',
        val_output_filename = 'simulation_track_2d_density_temporalBackground_p00000.res',
    )
)

### ATELES JOB 46
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = linearEulerdir + 'gradients/ateles_recheck.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        prefix = 'linearEuler_gradients',
        label =  'linearEuler_gradients_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = linearEulerdir + 'gradients/ref_linearEuler_gradients_track_grads_p00000.res',
        val_output_filename = 'linearEuler_gradients_track_grads_p00000.res',
    )
)

### ATELES JOB 47
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'shear-hat/2D/ateles_shearhat2D_recheck.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        label = 'shearhat2D',
        attachment = True,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'shear-hat/2D/ref_simulation_track_shearhat2D_p00000.res',
        val_output_filename = 'simulation_track_shearhat2D_p00000.res'
    )
)

### ATELES JOB 48
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'shear-hat/3D/ateles_shearhat3D_recheck.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        label = 'shearhat3D',
        attachment = True,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'shear-hat/3D/ref_simulation_track_shearhat3D_p00000.res',
        val_output_filename = 'simulation_track_shearhat3D_p00000.res'
    )
)

### ATELES JOB 49
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'shear-tube/shear_tube_recheck.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        label = 'sheartube',
        attachment = True,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'shear-tube/ref_shear_tube_track_momentum_p00000.res',
        val_output_filename = 'shear_tube_track_momentum_p00000.res'
    )
)

### ATELES JOB 50
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'use_modal_estimate/3D/ateles_modalest3D_recheck.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        label = 'modalest3D',
        attachment = True,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'use_modal_estimate/3D/ref_modalest_3d_point_series_p00000.res',
        val_output_filename = 'modalest_3d_point_series_p00000.res'
    )
)

### ATELES JOB 51
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'use_modal_estimate/2D/ateles_modalest2D_recheck.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        label = 'modalest2D',
        attachment = True,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'use_modal_estimate/2D/ref_modalest_2d_point_series_p00000.res',
        val_output_filename = 'modalest_2d_point_series_p00000.res'
    )
)

### ATELES JOB 52
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'use_modal_estimate/1D/ateles_modalest1D_recheck.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        label = 'modalest1D',
        attachment = True,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'use_modal_estimate/1D/ref_modalest_1d_point_series_p00000.res',
        val_output_filename = 'modalest_1d_point_series_p00000.res'
    )
)

### ATELES JOB 53
shepherd_jobs.append(
    dict(
        executable = seeder_exe,
        template = fluiddir + 'material/multilevel/seeder.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        prefix = 'matml_Q8',
        label = 'matml_Q8_seeder',
        mail = False
    )
)
shepherd_jobs.append(
    dict(
        executable = ateles_exe,
        solver_name = 'ateles',
        template = fluiddir + 'material/multilevel/ateles_matml_recheck.lua',
        extension = 'lua',
        run_exec = True,
        abort_failure = abort,
        additional_params = dict(testsuite_path=atldir),
        depend = ['matml_Q8_seeder'],
        label = 'matml_Q8_ateles',
        attachment = False,
        validation = True,
        val_method = 'difference',
        val_ref_path = fluiddir + 'material/multilevel/ref_matml_reflected_pulse_microphone_p00000.res',
        val_output_filename = 'matml_reflected_pulse_microphone_p00000.res',
    )
)
