#ifndef INCLUDED_SAVEFILE_H
#define INCLUDED_SAVEFILE_H

#define ITEM_VERSION    4

/* load-old.c */
/* int rd_savefile_old(void); */

/* bool older_than(int x, int y, int z); */

/* savefile.c */

/* Writing bits */
void wr_byte(byte v);
void wr_u16b(u16b v);
void wr_s16b(s16b v);
void wr_u32b(u32b v);
void wr_s32b(s32b v);
void wr_string(cptr str);

/* Reading bits */
void rd_byte(byte *ip);
void rd_u16b(u16b *ip);
void rd_s16b(s16b *ip);
void rd_u32b(u32b *ip);
void rd_s32b(s32b *ip);
void rd_string(char *str, int max);
void strip_bytes(int n);

/* load.c */

/* Utility */
void note(cptr msg);

/* Load stuff */
s16b rd_spell_set(void);

int rd_randomizer(void);
int rd_options(void);
int rd_messages(void);
int rd_monster_memory(void);
int rd_object_memory(void);
int rd_quests(void);
int rd_artifacts(void);
int rd_player(void);
int rd_squelch(void);
int rd_misc(void);
int rd_player_hp(void);
int rd_player_spells(void);
int rd_randarts(void);
int rd_inventory(void);
int rd_stores(void);
int rd_dungeon(void);
int rd_objects(void);
int rd_monsters(void);
int rd_history(void);

/* save.c */
void wr_spell_set(const object_type *o_ptr);

void wr_randomizer(void);
void wr_options(void);
void wr_messages(void);
void wr_monster_memory(void);
void wr_object_memory(void);
void wr_quests(void);
void wr_artifacts(void);
void wr_player(void);
void wr_squelch(void);
void wr_misc(void);
void wr_player_hp(void);
void wr_player_spells(void);
void wr_randarts(void);
void wr_inventory(void);
void wr_stores(void);
void wr_dungeon(void);
void wr_objects(void);
void wr_monsters(void);
void wr_history(void);

#endif /* INCLUDED_SAVEFILE_H */
