/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionWidgetLayout
implements Layout {
    private ConnectionWidget connectionWidget;
    private HashMap<Widget, LayoutFactory.ConnectionWidgetLayoutAlignment> alignments;
    private HashMap<Widget, Float> percentagePlacements;
    private HashMap<Widget, Integer> distancePlacements;

    public ConnectionWidgetLayout(ConnectionWidget connectionWidget) {
        this.connectionWidget = connectionWidget;
    }

    public void setConstraint(Widget widget, LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment, float f) {
        assert (widget != null);
        assert (connectionWidgetLayoutAlignment != null);
        if (this.alignments == null) {
            this.alignments = new HashMap();
        }
        this.alignments.put(widget, connectionWidgetLayoutAlignment);
        if (this.percentagePlacements == null) {
            this.percentagePlacements = new HashMap();
        }
        this.percentagePlacements.put(widget, Float.valueOf(f));
        if (this.distancePlacements != null) {
            this.distancePlacements.remove(widget);
        }
    }

    public void setConstraint(Widget widget, LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment, int n) {
        assert (widget != null);
        assert (connectionWidgetLayoutAlignment != null);
        if (this.alignments == null) {
            this.alignments = new HashMap();
        }
        this.alignments.put(widget, connectionWidgetLayoutAlignment);
        if (this.percentagePlacements != null) {
            this.percentagePlacements.remove(widget);
        }
        if (this.distancePlacements == null) {
            this.distancePlacements = new HashMap();
        }
        this.distancePlacements.put(widget, n);
    }

    public void removeConstraint(Widget widget) {
        assert (widget != null);
        if (this.alignments != null) {
            this.alignments.remove(widget);
        }
        if (this.percentagePlacements != null) {
            this.percentagePlacements.remove(widget);
        }
        if (this.distancePlacements != null) {
            this.distancePlacements.remove(widget);
        }
    }

    @Override
    public void layout(Widget widget) {
        assert (this.connectionWidget == widget);
        this.connectionWidget.calculateRouting();
        List<Point> list = this.connectionWidget.getControlPoints();
        boolean bl = list == null || list.size() <= 0;
        double d = 0.0;
        double[] dArray = new double[bl ? 0 : list.size() - 1];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d += GeomUtil.distanceSq(list.get(i), list.get(i + 1));
        }
        for (Widget widget2 : widget.getChildren()) {
            Integer n;
            Float f = this.percentagePlacements != null ? this.percentagePlacements.get(widget2) : null;
            Integer n2 = n = this.distancePlacements != null ? this.distancePlacements.get(widget2) : null;
            if (bl) {
                this.layoutChildAt(widget2, new Point());
                continue;
            }
            if (f != null) {
                if ((double)f.floatValue() <= 0.0) {
                    this.layoutChildAt(widget2, this.connectionWidget.getFirstControlPoint());
                    continue;
                }
                if ((double)f.floatValue() >= 1.0) {
                    this.layoutChildAt(widget2, this.connectionWidget.getLastControlPoint());
                    continue;
                }
                this.layoutChildAtDistance(dArray, (int)((double)f.floatValue() * d), widget2, list);
                continue;
            }
            if (n != null) {
                if (n < 0) {
                    this.layoutChildAtDistance(dArray, n + (int)d, widget2, list);
                    continue;
                }
                this.layoutChildAtDistance(dArray, n, widget2, list);
                continue;
            }
            this.layoutChildAt(widget2, new Point());
        }
    }

    @Override
    public boolean requiresJustification(Widget widget) {
        return false;
    }

    @Override
    public void justify(Widget widget) {
    }

    private void layoutChildAtDistance(double[] dArray, int n, Widget widget, List<Point> list) {
        int n2 = dArray.length - 1;
        for (int i = 0; i < dArray.length; ++i) {
            if (!((double)n < dArray[i])) continue;
            n2 = i;
            break;
        }
        double d = n2 > 0 ? dArray[n2 - 1] : 0.0;
        double d2 = dArray[n2] - d;
        double d3 = (double)n - d;
        if (d2 == 0.0) {
            this.layoutChildAt(widget, list.get(n2));
            return;
        }
        Point point = list.get(n2);
        Point point2 = list.get(n2 + 1);
        double d4 = d3 / d2;
        this.layoutChildAt(widget, new Point((int)((double)point.x + (double)(point2.x - point.x) * d4), (int)((double)point.y + (double)(point2.y - point.y) * d4)));
    }

    private void layoutChildAt(Widget widget, Point point) {
        if (!widget.isVisible()) {
            widget.resolveBounds(new Point(point.x, point.y), new Rectangle());
            return;
        }
        Rectangle rectangle = widget.getPreferredBounds();
        LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment = null;
        if (this.alignments != null) {
            connectionWidgetLayoutAlignment = this.alignments.get(widget);
        }
        if (connectionWidgetLayoutAlignment == null) {
            connectionWidgetLayoutAlignment = LayoutFactory.ConnectionWidgetLayoutAlignment.NONE;
        }
        Point point2 = ConnectionWidgetLayout.getReferencePoint(connectionWidgetLayoutAlignment, rectangle);
        Point point3 = widget.getPreferredLocation();
        if (point3 != null) {
            point2.translate(-point3.x, -point3.y);
        }
        widget.resolveBounds(new Point(point.x - point2.x, point.y - point2.y), rectangle);
    }

    private static Point getReferencePoint(LayoutFactory.ConnectionWidgetLayoutAlignment connectionWidgetLayoutAlignment, Rectangle rectangle) {
        switch (connectionWidgetLayoutAlignment) {
            case BOTTOM_CENTER: {
                return new Point(GeomUtil.centerX(rectangle), rectangle.y - 1);
            }
            case BOTTOM_LEFT: {
                return new Point(rectangle.x + rectangle.width, rectangle.y - 1);
            }
            case BOTTOM_RIGHT: {
                return new Point(rectangle.x - 1, rectangle.y - 1);
            }
            case CENTER: {
                return GeomUtil.center(rectangle);
            }
            case CENTER_LEFT: {
                return new Point(rectangle.x + rectangle.width, GeomUtil.centerY(rectangle));
            }
            case CENTER_RIGHT: {
                return new Point(rectangle.x - 1, GeomUtil.centerY(rectangle));
            }
            case NONE: {
                return new Point();
            }
            case TOP_CENTER: {
                return new Point(GeomUtil.centerX(rectangle), rectangle.y + rectangle.height);
            }
            case TOP_LEFT: {
                return new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            }
            case TOP_RIGHT: {
                return new Point(rectangle.x - 1, rectangle.y + rectangle.height);
            }
        }
        return new Point();
    }
}

