<?php
/**
 * Uploaded File Class
 * @package	Adelie
 */
namespace Adelie;

class UploadedFile
{
	private $name;
	private $type;
	private $tmp_name;
	private $error;
	private $size;

	/**
	 * constructor
	 * @access	private
	 * @param	string	$name
	 * @param	string	$idx
	 */
	public function __construct ($name, $idx="")
	{
		$flg = \strlen($idx) ? true : false; // whether array or not.
		if ($flg) { // in case of array
			$this->name = isset($_FILES[$name]["name"][$idx]) ? $_FILES[$name]["name"][$idx] : "";
			$this->type = isset($_FILES[$name]["type"][$idx]) ? $_FILES[$name]["type"][$idx] : "";
			$this->tmp_name = isset($_FILES[$name]["tmp_name"][$idx]) ? $_FILES[$name]["tmp_name"][$idx] : "";
			$this->error = isset($_FILES[$name]["error"][$idx]) ? $_FILES[$name]["error"][$idx] : 0;
			$this->size = isset($_FILES[$name]["size"][$idx]) ? $_FILES[$name]["size"][$idx] : 0;
		} else { // in case of others
			$this->name = isset($_FILES[$name]["name"]) ? $_FILES[$name]["name"] : "";
			$this->type = isset($_FILES[$name]["type"]) ? $_FILES[$name]["type"] : "";
			$this->tmp_name = isset($_FILES[$name]["tmp_name"]) ? $_FILES[$name]["tmp_name"] : "";
			$this->error = isset($_FILES[$name]["error"]) ? $_FILES[$name]["error"] : 0;
			$this->size = isset($_FILES[$name]["size"]) ? $_FILES[$name]["size"] : 0;
		}
	}

	/**
	 * get the path on the client machine
	 * @access	public
	 * @return	string
	 */
	public function getName ()
	{
		return $this->name;
	}

	/**
	 * get the mime type of the file
	 * @access	public
	 * @return	string
	 */
	public function getType ()
	{
		return $this->type;
	}

	/**
	 * get the path on the server
	 * @access	public
	 * @return	string
	 */
	public function getTmpName ()
	{
		return $this->tmp_name;
	}

	/**
	 * get the error code
	 * @access	public
	 * @return	integer
	 * @see	http://jp2.php.net/manual/ja/features.file-upload.errors.php
	 */
	public function getError ()
	{
		return $this->error;
	}

	/**
	 * get the file size
	 * @access	public
	 * @return	integer
	 */
	public function getSize ()
	{
		return $this->size;
	}

	/**
	 * wether the file is the uploaded file or not
	 * @access	public
	 * @return	boolean
	 */
	public function isUploaded ()
	{
		return \is_uploaded_file($this->tmp_name);
	}

	/**
	 * move the temporary file
	 * @access	public
	 * @param	string	$dest
	 * @return	void
	 * @throws	\RuntimeException
	 */
	public function move ($dest)
	{
		$ret = @\move_uploaded_file($this->tmp_name, $dest);
		if (!$ret) {
			$msg = namespace\Error::last();
			throw new \RuntimeException($msg, namespace\Error::E_MOVE);
		}
	}
}
