<?php
/**
 * Shortcut Class
 * @package	Adelie
 */
namespace Adelie;

final class Shortcut
{
	/**
	 * constructor
	 * @access	private
	 */
	private function __construct ()
	{
	}

	/**
	 * echo
	 * @static
	 * @access	public
	 * @param	string	$var
	 * @return	void
	 */
	static public function e ($var="")
	{
		echo $var;
	}

	/**
	 * htmlspecialchars
	 * @static
	 * @access	public
	 * @param	string	$var
	 * @return	string
	 */
	static public function h ($var="")
	{
		return \htmlspecialchars($var);
	}

	/**
	 * nl2br
	 * @static
	 * @access	public
	 * @param	string	$var
	 * @return	string
	 */
	static public function n ($var="")
	{
		return \nl2br($var);
	}

	/**
	 * sprintf
	 * @static
	 * @access	public
	 * @param	string	$format
	 * @param	mixed	$args, ...
	 * @return	string
	 */
	static public function f ($format, $args)
	{
		$args = \func_get_args();
		$format = \array_shift($args);
		return \vsprintf($format, $args);
	}

	/**
	 * number_format
	 * @static
	 * @access	public
	 * @param	mixed	$var
	 * @return	string
	 */
	static public function nf ($var=0)
	{
		return \number_format($var);
	}

	/**
	 * var_dump
	 * @static
	 * @access	public
	 * @param	mixed	$var
	 * @return	void
	 */
	static public function v ($var=null)
	{
		\var_dump($var);
	}

	/**
	 * echo, htmlspecialchars
	 * @static
	 * @access	public
	 * @param	string	$var
	 * @return	void
	 */
	static public function eh ($var="")
	{
		echo \htmlspecialchars($var);
	}

	/**
	 * echo, nl2br, htmlspecialchars
	 * @static
	 * @access	public
	 * @param	string	$var
	 * @return	void
	 */
	static public function enh ($var="")
	{
		echo \nl2br(\htmlspecialchars($var));
	}
}
