<?php
/**
 * Server Variables Class
 * @package	Adelie
 */
namespace Adelie;

final class Server
{
	/**
	 * constructor
	 * @access	private
	 */
	private function __construct ()
	{
	}

	/**
	 * get the super global variable $_SERVER
	 * @static
	 * @access	public
	 * @param	string	$key	variable key
	 * @param	string	$alternative	alternative variable key
	 * @return	string
	 */
	public static function __callStatic ($key, $alternative)
	{
		$key = \strtoupper(namespace\String::toUnderScore($key));
		$val = isset($_SERVER[$key]) ? $_SERVER[$key] : "";
		if (!\strlen($val) && \strlen($alternative)) {
			$key = \strtoupper($alternative);
			$val = isset($_SERVER[$key]) ? $_SERVER[$key] : "";
		}
		return $val;
	}
}
