<?php
/**
 * Cookie Class
 * @package	Adelie
 */
namespace Adelie;

final class Cookie
{
	private static $instance;

	/**
	 * constructor
	 * @access	private
	 */
	private function __construct ()
	{
	}

	/**
	 * get the instance
	 * @access	public
	 * @static
	 * @return	\Adelie\Cookie
	 */
	public static function getInstance ()
	{
		if (self::$instance==null) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * set cookie value
	 * @access	public
	 * @param	string	$key
	 * @param	string	$val
	 * @param	integer	$expire
	 * @param	string	$path
	 * @param	string	$domain
	 * @param	false	$secure
	 * @param	false	$httponly
	 * @return	void
	 */
	public function set ($key, $val="", $expire=0, $path="", $domain="", $secure=false, $httponly=false)
	{
		\setcookie($key, $val, $expire, $path, $domain, $secure, $httponly);
	}

	/**
	 * get cookie value
	 * @access	public
	 * @param	string	$key
	 * @return	mixed
	 */
	public function get ($key)
	{
		return isset($_COOKIE[$key]) ? $_COOKIE[$key] : "";
	}

	/**
	 * delete cookie value
	 * @access	public
	 * @param	string	$key
	 * @param	string	$path
	 * @param	string	$domain
	 * @return	void
	 */
	public function delete ($key, $path="", $domain="")
	{
		\setcookie($key, "", (\time()-3600), $path, $domain);
	}
}
