<?php
/**
 * SQLite Class
 * @package	Adelie
 * @copyright	Copyright (c) 2012, Adelie Development Team
 */
namespace Adelie;

require_once \sprintf("phar://%s/core/db/AbstractDb.php", namespace\PHAR);
require_once \sprintf("phar://%s/core/db/DbSqliteInfo.php", namespace\PHAR);

class DbSqlite extends namespace\AbstractDb
{
	/**
	 * constructor
	 * @access	protected
	 * @param	string	$dsn	\Adelie\DSN
	 * @param	array	$opts	array of driver-specific connection options
	 * @return	void
	 */
	protected function __construct (namespace\Dsn $dsn, Array $opts=array())
	{
		parent::__construct($dsn, $opts);
	}

	/**
	 * connect
	 * @access	protected
	 * @return	void
	 */
	protected function connect ()
	{
		$this->pdo = new \PDO($this->dsn->create(), "", "", $this->opts);
	}
}
