<?php
/**
 * Abstract Database Informaion Class
 * @package	Adelie
 * @copyright	Copyright (c) 2012, Adelie Development Team
 */
namespace Adelie;

abstract class AbstractDbInfo
{
	protected $db;
	protected $columns;

	/**
	 * constractor
	 * @access	public
	 * @param	\Adelie\Abstract	$db
	 */
	public function __construct (namespace\AbstractDb $db)
	{
		$this->db = $db;
		$this->columns = array();
	}

	/**
	 * get tables
	 * @access	public
	 * @return	array
	 */
	public function getTables ()
	{
		return \array_keys($this->columns);
	}

	/**
	 * get columns
	 * @access	public
	 * @param	string	$table
	 * @return	array
	 */
	public function getColumns ($table)
	{
		return isset($this->columns[$table]) ? $this->columns[$table] : array();
	}

	/**
	 * get PDO data type corresponding to the passed $type
	 * @abstract
	 * @access	protected
	 * @param	string	$type
	 * @return	integer
	 */
	abstract protected function getPdoType ($type);

	/**
	 * get PHP data type corresponding to the passed $type
	 * @abstract
	 * @access	protected
	 * @param	string	$type
	 * @return	integer
	 */
	abstract protected function getPhpType ($type);
}
