<?php
/**
 * Router Class
 * @package	Adelie
 * @copyright	Copyright (c) 2012, Adelie Development Team
 */
namespace Adelie;

final class Router
{
	private static $instance;
	private static $patterns;
	private static $terminate;

	private $request;

	/**
	 * constructor
	 * @access	private
	 * @param	\Adelie\Request	$request
	 */
	private function __construct (namespace\Request $request)
	{
		$this->request = $request;
		self::$patterns = array();
	}

	/**
	 * create instance
	 * @static
	 * @access	public
	 * @param	\Adelie\Request	$request
	 * @return	\Adelie\Router
	 */
	public static function getInstance (namespace\Request $request)
	{
		if (self::$instance==null) {
			self::$instance = new self($request);
		}
		return self::$instance;
	}

	/**
	 * routing
	 * @access	public
	 * @return	\Adelie\Request
	 */
	public function route ()
	{
		$path = isset($_SERVER["PATH_INFO"]) ? $_SERVER["PATH_INFO"] : "";
		$paths = \explode("/", \trim($path, "/"));

		$ok = false;
		if (count(self::$patterns)) {
			foreach (self::$patterns as $val) {
				$pattern = $val["pattern"];
				$controller = $val["controller"];
				$action = $val["action"];
				if (\preg_match("/{$pattern}/", $path)) {
					$this->request->setController($controller);
					$this->request->setAction($action);
					$ok = true;
					break;
				}
			}
		}
		if ($ok || self::$terminate===true) { return $this->request; }

		// Controller & Action
		if (\count($paths)==1) {
			if ($paths[0]) {
				$this->request->setController(\array_shift($paths));
			} else {
				$this->request->setController(namespace\DEFAULT_CONTROLLER);
			}
			$this->request->setAction();
		} else {
			$this->request->setController(\array_shift($paths));
			$this->request->setAction(\array_shift($paths));
		}

		return $this->request;
	}

	/**
	 * set routing rules
	 * @static
	 * @access	public
	 * @param	string	$pattern
	 * @param	string	$controller
	 * @param	string	$action
	 */
	public static function set ($pattern, $controller, $action)
	{
		self::$patterns[] = array(
			"pattern" => $pattern,
			"controller" => $controller,
			"action" => $action
		);
	}

	/**
	 * terminate user defined routing
	 * @static
	 * @access	public
	 * @return	void
	 */
	public static function terminate ()
	{
		self::$terminate = true;
	}
}
