<?php
/**
 * Dispatcher Class
 * @package	Adelie
 * @copyright	Copyright (c) 2012, Adelie Development Team
 */
namespace Adelie;

final class Dispatcher
{
	/**
	 * dispatch
	 * @access	public
	 * @static
	 * @param	\Adelie\Request		$request
	 * @return	\Adelie\Response
	 */
	public static function dispatch (namespace\Request $request, \Exception $exception=null)
	{
		// コントローラーファイルの存在をチェック
		$controller_path = $request->getControllerPath();
		if (!\is_readable($controller_path)) {
			$request->setController(\sprintf("\\%s\\%s", __NAMESPACE__, ERROR_CONTROLLER));
			$controller_path = $request->getControllerPath();
			$request->setAction("404");
		}
		require_once $controller_path;

		// アクションコントローラーオブジェクトの存在をチェック
		$controller_name = $request->getControllerName();
		if (!\class_exists($controller_name) || !\is_subclass_of($controller_name, "\\".__NAMESPACE__."\\AbstractController")) {
			$request->setController(namespace\ERROR_CONTROLLER);
			require_once $request->getControllerPath();
			$controller_name = $request->getControllerName();
			$request->setAction("404");
		}
		$controller = new $controller_name($request, $exception);

		// アクションメソッドの存在をチェック
		$action_method = $request->getActionMethod();
		if (!\is_callable(array($controller, $action_method))) {
			$request->setAction(namespace\DEFAULT_ACTION);
			$action_method = $request->getActionMethod();
		}

		// 実行
		\call_user_func(array($controller, $action_method));
		return $controller->getResponse();
	}

}
