<?php
/**
 * Setup Adelie Framework
 */
namespace Adelie;

// Closure
$define = function($key, $val) { \define(\sprintf("%s\\%s", __NAMESPACE__, $key), $val); };
$require = function ($path) { require_once \sprintf("phar://%s%s", namespace\PHAR, $path); };

// Basic Information
$phar = new \Phar("phar://Adelie.phar");
$define("PHAR", \basename($phar->running(false))); // Phar File Name
$define("NAME", "Adelie"); // Framework Name
$define("VERSION", "0.1.0"); // Version
$define("MAJOR_VERSION", 0);
$define("MINOR_VERSION", 1);
$define("RELEASE_VERSION", 0);
$define("EXTRA_VERSION", "");
$define("VERSION_ID", namespace\MAJOR_VERSION * 10000 + namespace\MINOR_VERSION * 100 + namespace\RELEASE_VERSION);
$define("COPYRIGHT", "Copyright (C) 2012 ".namespace\NAME." Framework All Rights Reserved."); // Copyright

// Start up information
$define("START_TIME", isset($_SERVER["REQUEST_TIME"]) ? $_SERVER["REQUEST_TIME"] : \time());
$define("START_MTIME", isset($_SERVER["REQUEST_TIME_FLOAT"]) ? $_SERVER["REQUEST_TIME_FLOAT"] : \microtime(true));
$define("HOST_NAME", \php_uname("n"));
$tmp = \explode(".", namespace\HOST_NAME);
$define("HOST_SNAME", \array_shift($tmp));

// Directory
$define("SYS_ROOT", \dirname($phar->running(false)));
$define("DIR_APP",	namespace\SYS_ROOT."/app");
$define("DIR_VAR",	namespace\SYS_ROOT."/var");
$define("DIR_CLI",	namespace\DIR_APP."/cli");
$define("DIR_CNF",	namespace\DIR_APP."/cnf");
$define("DIR_CTL",	namespace\DIR_APP."/ctl");
$define("DIR_DAO",	namespace\DIR_APP."/dao");
$define("DIR_LIB",	namespace\DIR_APP."/lib");
$define("DIR_TPL",	namespace\DIR_APP."/tpl");
$define("DIR_DAT",	namespace\DIR_VAR."/dat");
$define("DIR_LCK",	namespace\DIR_VAR."/lock");
$define("DIR_LOG",	namespace\DIR_VAR."/log");
$define("DIR_SESS",	namespace\DIR_VAR."/sess");
$define("DIR_TMP",	namespace\DIR_VAR."/tmp");

// checking API
switch (\php_sapi_name()) {
	case "cli":
		$define("WEB", false);
		$define("CLI", true);
		break;
	case "cgi":
	case "cgi-fcgi":
		if (isset($_SERVER["HTTP_HOST"])) {
			$define("WEB", true);
			$define("CLI", false);
		} else {
			$define("WEB", false);
			$define("CLI", true);
		}
		break;
	default:
		$define("WEB", true);
		$define("CLI", false);
		break;
}

// internationalization
if (\extension_loaded("mbstring")) {
	$define("I18N", "mbstring");
} else if (\extension_loaded("iconv")) {
	$define("I18N", "iconv");
} else {
	$define("I18N", "");
}


// loading Adelie libraries.
if (namespace\WEB) {
	$require("/core/AbstractController.php");
	$require("/core/Adelie.php");
} else if (namespace\CLI) {
	$require("/core/AbstractCli.php");
	$require("/core/Cli.php");
}
$require("/core/Error.php");
$require("/core/AdelieException.php");
$require("/core/db/AbstractDao.php");
$require("/core/db/Dsn.php");

// Auto Loading
\spl_autoload_register(function ($class) {
	$tmp = \explode("\\", \trim($class, "\\"));
	// Dao
	if ($tmp[0]==__NAMESPACE__ && \substr((isset($tmp[2]) ? $tmp[2] : ""), -3)=="Dao") {
		$tmp[1] = \substr($tmp[1], 0, \strlen($tmp[1])-3);
		$path = \sprintf("%s%s%s%s%s.php", namespace\DIR_DAO, DIRECTORY_SEPARATOR, namespace\String::toUnderScore($tmp[1]), DIRECTORY_SEPARATOR, $tmp[2]);
		if (\file_exists($path)) {
			require_once $path;
		}
	// Library
	} else if ($tmp[0]==__NAMESPACE__) {
		$path = \sprintf("phar://%s%slib%s%s.php", namespace\PHAR, DIRECTORY_SEPARATOR, DIRECTORY_SEPARATOR, (isset($tmp[1]) ? $tmp[1] : ""));
		if (\file_exists($path)) {
			require_once $path;
		}
	}
});


// Error Handling
\set_error_handler(
	function ($errno, $errstr, $errfile, $errline, $errcontext) {
		switch ($errno) {
			case E_USER_ERROR:
				exit(E_USER_ERROR);
				break;
			case E_USER_WARNING:
				break;
			case E_USER_NOTICE:
				break;
			default:
				break;
		}
		return false;
	},
	\error_reporting()
);

// Exception Handling
\set_exception_handler(
	function (\Exception $e) {
		Error::webForObject($e);
	}
);







// clean up
unset($phar);
unset($define);
unset($require);
unset($tmp);


// execute
if (namespace\WEB) {
	require_once \sprintf("%s%sadelie.php", namespace\DIR_CNF, DIRECTORY_SEPARATOR);
} else if (namespace\CLI) {
	if (\strcasecmp(@$_SERVER["argv"][1], "@setup")) {
		require_once \sprintf("%s%sadelie.php", namespace\DIR_CNF, DIRECTORY_SEPARATOR);
	}
	$cli = namespace\Cli::getInstance();
	$cli->run();
}
