<?php
/**
 * SQLite Information Class
 * @package	Adelie
 * @copyright	Copyright (c) 2012, Adelie Development Team
 */
namespace Adelie;

require_once \sprintf("phar://%s/core/db/AbstractDbInfo.php", namespace\PHAR);
require_once \sprintf("phar://%s/core/db/DbSqlite.php", namespace\PHAR);

final class DbSqliteInfo extends namespace\AbstractDbInfo
{
	/**
	 * constructor
	 * @access	public
	 * @param	\Adelie\AbstractDb	$dsn
	 */
	public function __construct (namespace\AbstractDb $db)
	{
		parent::__construct($db);

		// get table name
		$sql  = "SELECT tbl_name FROM sqlite_master WHERE type = 'table' ";
		$sql .= "AND tbl_name NOT IN ('sqlite_master', 'sqlite_sequence') ";
		$sql .= "ORDER BY tbl_name ";
		$db->prepare($sql);
		$db->exec();
		while ($db->fetch()) {
			$this->columns[$db->get("tbl_name")] = array();
		}
		$db->free();

		// get column
		$tables = \array_keys($this->columns);
		foreach ($tables as $table) {
			$db->prepare("PRAGMA TABLE_INFO('{$table}') ");
			$db->exec();
			while ($db->fetch()) {
				$name = \strtolower($db->get("name"));
				$this->columns[$table][$name] = array(
					"php_type" => $this->getPhpType($db->get("type")),
					"pdo_type" => $this->getPdoType($db->get("type"))
				);
			}
		}
	}

	/**
	 * get PDO data type corresponding to the passed $type
	 * @access	protected
	 * @param	string	$type
	 * @return	integer
	 */
	protected function getPdoType ($type)
	{
		$type = \strtolower($type);
		switch ($type) {
			case "integer":
				$cast = "\\PDO::PARAM_INT";
				break;
			case "blob":
				$cast = "\\PDO::PARAM_LOB";
				break;
			case "null":
				$cast = "\\PDO::PARAM_NULL";
				break;
			default:
				$cast = "\\PDO::PARAM_STR";
				break;
		}
		return $cast;
	}

	/**
	 * get PHP data type corresponding to the passed $type
	 * @access	protected
	 * @param	string	$type
	 * @return	string
	 */
	protected function getPhpType ($type)
	{
		$type = \strtolower($type);
		switch ($type) {
			case "integer":
				$cast = "intval";
				break;
			case "real":
				$cast = "floatval";
				break;
			case "blob":
			case "null":
				$cast = "";
				break;
			default:
				$cast = "strval";
				break;
		}
		return $cast;
	}
}
