<?php
/**
 *
 * @package	Adelie
 * @copyright	Copyright (c) 2012, Adelie Development Team
 */
namespace Adelie;

final class SkeltonCli extends namespace\AbstractCli
{
	const TYPE_CTL = 1;
	const TYPE_CLI = 2;

	private $params;

	public function __contruct ()
	{
		parent::__construct();
		$this->params = array();
	}

	/**
	 * ヘルプを表示
	 * @access	public
	 * @return	void
	 */
	public function help ()
	{
		echo "\n";
		echo "Usage: php ".namespace\PHAR." @".$this->getProgName()." TYPE NAME [DESC]\n";
		echo "\n";
		echo "TYPE: input a number 1 or 2. required.\n";
		echo "  1    create Controller Object.\n";
		echo "  2    create CLI Object.\n";
		echo "\n";
		echo "NAME: input an object name. required.\n";
		echo "\n";
		echo "DESC: input description. option.\n";
		echo "\n";
	}

	private function create ($src, $dst)
	{
		$contents = file_get_contents($src);
		$searches = array("###DESCRIPTION###", "###OBJECT_NAME###", "###DEFAULT_ACTION###");

	}

	/**
	 * 実行
	 * @access	public
	 * @return	void
	 */
	public function run ()
	{
		$type = $this->get(0);
		$name = $this->get(1);
		$explain = trim($this->get(2));

		// パラメータチェック
		$error = false;
		switch ($type) {
			case self::TYPE_CTL:
				$src = "phar://".namespace\PHAR."/etc/ControllerSkelton.txt";
				$dst = namespace\DIR_CTL."/{$name}Controller.php";
				break;
			case self::TYPE_CLI:
				$src = "phar://".PHAR."/etc/CliSkelton.txt";
				$dst = namespace\DIR_CLI."/{$name}Cli.php";
				break;
			default:
				$error = true;
				break;
		}
		if (!strlen($name)) {
			$error = true;
		}
		if ($error) {
			$this->help();
			return;
		}

		// 生成
		$contents = \file_get_contents($src);
		$searches = array("###DESCRIPTION###", "###OBJECT_NAME###", "###DEFAULT_ACTION###");

	}
}
