<?php
/**
 * DAO Creator Class
 *
 * @package	Adelie
 * @copyright	Copyright (c) 2012, Adelie Development Team
 */
namespace Adelie;

final class DaoCli extends namespace\AbstractCli
{
	const E_INVALID_DSN = 1;

	/**
	 * constructor
	 * @access	public
	 */
	public function __construct ()
	{
		parent::__construct();
	}

	/**
	 * create DAO file
	 * @access	private
	 * @param	\Adelie\AbstractDbInfo	$info
	 * @param	string	$namespace
	 * @return	void
	 */
	private function createDao (namespace\AbstractDbInfo $info, $namespace)
	{
		$ns_c = namespace\String::toUnderScore($namespace);
		$dir = \sprintf("%s/%s", namespace\DIR_DAO, $ns_c);
		if (!\file_exists($dir)) {
			$ret = @\mkdir($dir, 0755);
			if (!$ret) {
				$msg = namespace\Error::get(namespace\Error::E_WRITE, $dir);
				throw new namespace\AdelieException($msg, namespace\Error::E_WRITE);
			}
		}

		echo ">>> creating DAO file ...\n";
		$tables = $info->getTables();
		$ns = __NAMESPACE__;
		foreach ($tables as $table) {
			$class_name = namespace\String::toPascal($table);
			echo "  * {$class_name}Dao\n";

			$buf  = "<?php ";
			$buf .= "namespace {$ns}\\{$namespace}Dao; ";
			$buf .= "require_once \\{$ns}\\DIR_DAO.\"/{$ns_c}_sql/{$class_name}DaoSql.php\"; ";
			$buf .= "final class {$class_name}Dao extends namespace\\{$class_name}DaoSql { ";
			$buf .=   "public function __construct (\\{$ns}\\Dsn \$dsn, \$opts=array()) { ";
			$buf .=     "parent::__construct(\$dsn, \$opts); ";
			$buf .=   "} ";
			$cols = $info->getColumns($table);
			foreach ($cols as $name=>$col) {
				$name_c = namespace\String::toPascal($name);
				$php_type = $col["php_type"];
				$pdo_type = $col["pdo_type"];
				// setHoge
				$buf .= "public function set{$name_c} (\$var=\"\") { ";
				$buf .=   "if (\is_null(\$var)) { ";
				$buf .=	    "\$this->vars[\"{$name}\"] = array(\"var\"=>null, \"type\"=>\\PDO::PARAM_NULL); ";
				$buf .=   "} else { ";
				if ($php_type) {
					$buf .= "\$this->vars[\"{$name}\"] = array(\"var\"=>\\{$php_type}(\$var), \"type\"=>{$pdo_type}); ";
				} else {
					$buf .= "\$this->vars[\"{$name}\"] = array(\"var\"=>\$var, \"type\"=>{$pdo_type}); ";
				}
				$buf .=   "} ";
				$buf .= "} ";
				// setHogeAlias
/* TODO:実装
				$buf .= "public function set{$name_c}Alias (\$var) { ";
				$buf .=   "\$this->aliases[\"{$name}\"] = \$val; ";
				$buf .= "} ";
*/
				// setHogeFunc
				// setHogeWhere
				$buf .= "public function set{$name_c}Where (\$var, \$ope=\"=\") { ";
				$buf .=   "if (\is_null(\$var)) { ";
				$buf .=     "\$this->wheres[\"{$name}\"][] = array(\"val\"=>null, \"ope\"=>\$ope, \"type\"=>\\PDO::PARAM_NULL); ";
				$buf .=   "} else if (\is_array(\$var)) { ";
				if ($php_type) {
					$buf .= "foreach (\$var as \$key=>\$val) { ";
					$buf .=   "\$var[\$key] = \\{$php_type}(\$val); ";
					$buf .= "} ";
				}
				$buf .=     "\$this->wheres[\"{$name}\"][] = array(\"val\"=>\$val, \"ope\"=>\$ope, \"type\"=>{$pdo_type}); ";
				$buf .=   "} else { ";
				if ($php_type) {
					$buf .=   "\$this->wheres[\"{$name}\"][] = array(\"val\"=>\\{$php_type}(\$var), \"ope\"=>\$ope, \"type\"=>{$pdo_type}); ";
				} else {
					if ($pdo_type=="\\PDO::PARAM_LOB") {
						$buf .= "if (\\is_resource(\$val)) { ";
						$buf .=   "\$this->wheres[\"{$name}\"][] = array(\"val\"=>\$val, \"ope\"=>\$ope, \"type\"=>\\PDO::PARAM_LOB); ";
						$buf .= "} else { ";
						$buf .=   "\$this->wheres[\"{$name}\"][] = array(\"val\"=>\\strval(\$val), \"ope\"=>\$ope, \"type\"=>\\PDO::PARAM_STR); ";
						$buf .= "} ";
					} else {
						$buf .=   "\$this->wheres[\"{$name}\"][] = array(\"val\"=>\$val, \"ope\"=>\$ope, \"type\"=>{$pdo_type}); ";
					}
				}
				$buf .=   "} ";
				$buf .= "} ";
				// setHogeGroup
/* TODO:実装
				$buf .= "public function set{$name_c}Group () { ";
				$buf .=   "\$this->groups[\"{$name}\"] = true; ";
				$buf .= "} ";
*/
				// setHogeOrderAsc
				$buf .= "public function set{$name_c}OrderAsc () { ";
				$buf .=   "\$this->orders[\"{$name}\"] = \"ASC\"; ";
				$buf .= "} ";
				// setHogeOrderDesc
				$buf .= "public function set{$name_c}OrderDesc () { ";
				$buf .=   "\$this->orders[\"{$name}\"] = \"DESC\"; ";
				$buf .= "} ";
			}
			// setLimit
			$buf .= "public function setLimit (\$limit) { ";
			$buf .=   "\$this->limit = \\intval(\$limit); ";
			$buf .= "} ";
			// setOffset
			$buf .= "public function setOffset (\$offset) { ";
			$buf .=   "\$this->offset = \\intval(\$offset); ";
			$buf .= "} ";
			$buf .= "} ";
			// output
			$path = \sprintf("%s/%sDao.php", $dir, $class_name);
			\file_put_contents($path, $buf);
		}
	}

	/**
	 * create DAO SQL class files
	 * @access	private
	 * @param	\Adelie\AbstractDbInfo	$info
	 * @param	string	$namespace
	 * @return	void
	 */
	private function createDaoSql (namespace\AbstractDbInfo $info, $namespace)
	{
		$dir = \sprintf("%s/%s_sql", namespace\DIR_DAO, namespace\String::toUnderScore($namespace));
		if (!\file_exists($dir)) {
			$ret = @\mkdir($dir, 0755);
			if (!$ret) {
				$msg = namespace\Error::get(namespace\Error::E_WRITE, $dir);
				throw new namespace\AdelieException($msg, namespace\Error::E_WRITE);
			}
		}

		echo ">>> creating DAO SQL files ...\n";
		$tables = $info->getTables();
		foreach ($tables as $table) {
			$class_name = String::toPascal($table);
			$path = "{$dir}/{$class_name}DaoSql.php";
			if (\file_exists($path)) {
				continue;
			}
			echo "  * {$class_name}DaoSql\n";
			$ns = __NAMESPACE__;
			$sfo = new \SplFileObject($path, "wb");
			$sfo->fwrite("<?php\n");
			$sfo->fwrite("/**\n");
			$sfo->fwrite(" * {$class_name}DaoSql Class\n");
			$sfo->fwrite(" * \n");
			$sfo->fwrite(" * @package		{$ns}\n");
			$sfo->fwrite(" * @subpackage	{$namespace}Dao\n");
			$sfo->fwrite(" * @copyright	".COPYRIGHT."\n");
			$sfo->fwrite(" */\n");
			$sfo->fwrite("namespace {$ns}\\{$namespace}Dao;\n");
			$sfo->fwrite("\n");
			$sfo->fwrite("require_once \\sprintf(\"phar://%s/core/db/AbstractDao.php\", \\{$ns}\\PHAR);\n");
			$sfo->fwrite("\n");
			$sfo->fwrite("class {$class_name}DaoSql extends \\{$ns}\\AbstractDao\n");
			$sfo->fwrite("{\n");
			$sfo->fwrite("	/**\n");
			$sfo->fwrite("	 * constructor\n");
			$sfo->fwrite("	 * @access	public\n");
			$sfo->fwrite("	 * @param	\\{$ns}\\Dsn	\$dsn	Dsn object\n");
			$sfo->fwrite("	 * @param	array	\$opts	The options for PDO constructor.\n");
			$sfo->fwrite("	 */\n");
			$sfo->fwrite("	public function __construct (\\{$ns}\\Dsn \$dsn, \$opts)\n");
			$sfo->fwrite("	{\n");
			$sfo->fwrite("		parent::__construct(\$dsn, \$opts);\n");
			$sfo->fwrite("	}\n");
			$sfo->fwrite("\n");
			$sfo->fwrite("	/**\n");
			$sfo->fwrite("	 * do sample sql\n");
			$sfo->fwrite("	 * @access	protected\n");
			$sfo->fwrite("	 * @param	mixed	\$param	any parameter\n");
			$sfo->fwrite("	 * @return	string\n");
			$sfo->fwrite("	 */\n");
			$sfo->fwrite("	/*\n");
			$sfo->fwrite("	protected function doSampleSql (\$param)\n");
			$sfo->fwrite("	{\n");
			$sfo->fwrite("		\$sql = \"SELECT * FROM {\$this->table} WHERE column = :column\";\n");
			$sfo->fwrite("		\$this->db->bind(\"column\", \$param);\n");
			$sfo->fwrite("		return \$sql;\n");
			$sfo->fwrite("	}\n");
			$sfo->fwrite("	*/\n");
			$sfo->fwrite("}\n");
			$sfo->fflush();
		}
	}

	/**
	 * run
	 * @access	public
	 * @return	void
	 */
	public function run ()
	{
		$dsn = \sprintf("\\%s", $this->get(0));
		if (\strpos($dsn, "\\")===false) {
			$dsn = "\\{$dsn}";
		}
		if (!\defined($dsn)) {
			throw new \UnexpectedValueException("Invalid DSN ({$dsn}) parameter.", self::E_INVALID_DSN);
		}

		$dsn = new namespace\Dsn(\constant($dsn));
		$db = namespace\DbFactory::create($dsn);
		$info = $db->getInfo();
		$tables = $info->getTables();
		if (!\count($tables)) {
			//TODO:終了処理
			exit;
		}

		$namespace = $dsn->createNamespace();
		$this->createDao($info, $namespace);
		$this->createDaoSql($info, $namespace);
	}
}
