//------------------------------------------------------------------
// rbanner.js - Random Banner Library
// Author:      pine
// Version:     1.1
// Update:      19:25 2010/06/16
// License:     MIT License
//------------------------------------------------------------------

(function(global){
	
	// 定数の宣言 --------------------------------------------------
	
	var const_version = "1.1";
	
	
	// ロード時の引数の処理 ----------------------------------------
	
	var config = {
		className: "RBanner",
		sprintf:   "sprintf",
		enable:    "true",
		version:   "latest",
		target:    "_self"
	};
	
	(function(){
		var elements = document.getElementsByTagName("script");
		
		if(elements.length == 0) return;
		
		var element = elements[elements.length - 1];
		var src     = element.src;
		
		if(!src)                  return;
		if(!src.match(/\?(.+)$/)) return;
		
		var queryArray  = RegExp.$1.split("&");
		
		for(var i = 0; i < queryArray.length; ++i){
			var pair = queryArray[i].split("=");
			
			if(pair.length < 2)      continue;
			if(!pair[0] || !pair[1]) continue;
			
			config[pair[0]] = decodeURIComponent(pair[1]);
		}
	})();
	
	if(config.enable != "true"){
		return;
	}
	
	
	// 関数の定義 --------------------------------------------------
	
	eval("var _sprintf = " + config.sprintf);
	
	function define_global(name, value){
		global[name] = value;
	}
	
	function to_string(object){
		return Object.prototype.toString.call(object);
	}
	
	function to_array(object){
		var array = [];
		
		for(var i = 0; i < object.length; ++i){
			array.push(object[i]);
		}
		
		return array;
	}
	
	function is_array(object){
		return to_string(object) == "[object Array]";
	}
	
	function is_string(object){
		return to_string(object) == "[object String]";
	}
	
	function is_function(object){
		return to_string(object) == "[object Function]";
	}
	
	function is_number(object){
		return to_string(object) == "[object Number]";
	}
	
	function is_boolean(object){
		return to_string(object) == "[object Boolean]";
	}
	
	function get_rand(a, b){
		if(a > b){
			var t = a;
			a     = b;
			b     = t;
		}
		
		return Math.floor(Math.random() * (b - a + 1)) + a;
	}
	
	function rb_array(array){
		// empty
		if(!array.length){
			return "";
		} else
		
		// string
		if(is_string(array[0])){
			return array[get_rand(0, array.length - 1)];
		} else
		
		// range
		if(is_number(array[0]) && array.length % 2 == 0){
			var pattern = [];
			var max     = 0;
			
			for(var i = 0; i < array.length; i += 2){
				var count = Math.abs(array[i] - array[i+1]) + 1;
				pattern.push([max, max + count, get_rand(array[i], array[i+1])]);
				max += count;
			}
			
			var index = get_rand(0, max - 1);
			
			for(var i = 0; i < pattern.length; ++i){
				if(pattern[i][0] <= index && pattern[i][1] > index){
					return pattern[i][2];
				}
			}
		}
		
		// other
		else {
			return "";
		}
	}
	
	// rb_html(html, ...);
	// va_args:
	// [n, n+i, m, m+j, ...]
	//  -> (n <= and n+i >= ) or (m <= and m+j >=)
	// ["A", "B", "C"]
	//  -> "A" or "B" or "C"
	function rb_html(html){
		if(!html) return "";
		
		var args = [html];
		
		for(var i = 1; i < arguments.length; ++i){
			// string or number
			if(is_string(arguments[i]) || is_number(arguments[i])){
				args.push(arguments[i]);
			} else
			
			// boolean
			if(is_boolean(arguments[i])){
				args.push(String(arguments[i]));
			} else
			
			// function
			if(is_function(arguments[i])) {
				args.push(arguments[i]());
			} else
			
			// array
			if(is_array(arguments[i])){
				args.push(rb_array(arguments[i]));
			}
			
			// other
			else {
				args.push("");
			}
		}
		
		return _sprintf.apply(null, args);
	}
	
	// rb_easy(img_url);
	// rb_easy(img_url, alt);
	// rb_easy(img_url, alt, url);
	// rb_easy(img_url, alt, url, target);
	// rb_easy(img_url, width, height);
	// rb_easy(img_url, width, height, url);
	// rb_easy(img_url, width, height, url, target);
	// rb_easy(img_url, alt, width, height);
	// rb_easy(img_url, alt, width, height, url);
	// rb_easy(img_url, alt, width, height, url, target);
	function rb_easy(){
		if(arguments.length == 0)    return "";
		if(!is_string(arguments[0])) return "";
		
		var url, target = config.target;
		var image = [arguments[0]];
		var start = 1;
		
		(function(){
			if(is_string(arguments[1])){
				image[1] = arguments[1];
				++start;
			}
			
			if(is_number(arguments[1])){
				image[2] = arguments[1];
				image[3] = arguments[2];
				start += 2;
				
				if(is_string(arguments[3])){
					url = arguments[3];
					++start;
				}
				
				if(is_string(arguments[4])){
					target = arguments[4];
					++start;
				}
				
				return;
			}
			
			if(is_string(arguments[2])){
				url = arguments[2];
				++start;
			}
			
			if(is_number(arguments[2])){
				image[2] = arguments[2];
				image[3] = arguments[3];
				start += 2;
			}
			
			if(is_string(arguments[3])){
				target = arguments[3];
				++start;
			}
			
			if(is_string(arguments[4])){
				url = arguments[4];
				++start;
			}
			
			if(is_string(arguments[5])){
				target = arguments[5];
				++start;
			}
		}).apply(null, arguments);
		
		var src    = image[0];
		var alt    = image[1] || "";
		var width  = is_number(image[2]) ? image[2] + "px" : "auto";
		var height = is_number(image[3]) ? image[3] + "px" : "auto";
		
		var html = '<img src="' + src + '" alt="' + alt + '" ' +
		           'style="width:' + width + ';height:' + height + ';border:0px;">';
		
		if(url){
			html = '<a href="' + url + '" target="' + target + '">' + html + '</a>';
		}
		
		return rb_html.apply(null, [html].concat(to_array(arguments).slice(start)));
	}
	
	function to_write_function(func){
		return function(){
			document.write(func.apply(null, arguments));
		};
	}
	
	// インストール ------------------------------------------------
	
	(function(){
		var versions = config.version.split(",");
		
		for(var i = 0; i < versions.length; ++i){
			// latest
			if(versions[i] == "latest"){
				versions[i] = const_version;
			}
			
			// version 1.0
			if(versions[i] == "1.0"){
				define_global("RandomBanner", to_write_function(rb_html));
			} else
			
			// version 1.1
			if(versions[i] == "1.1"){
				var klass = to_write_function(rb_easy);
				
				klass.rb_easy  = rb_easy;
				klass.rbs_easy = to_write_function(rb_easy);
				klass.rb_html  = rb_html;
				klass.rbs_html = to_write_function(rb_html);
				
				define_global(config.className, klass);
			}
		}
	})();
	
})(this);