/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import jp.gr.java_conf.ussiy.app.propedit.util.AlreadyFileLockException;
import jp.gr.java_conf.ussiy.io.LockableFileOutputStream;

public class FileOpener
extends File {
    private ByteArrayOutputStream bin = null;
    private int encode;
    private StringBuffer txt = null;

    public FileOpener(File file) {
        super(file.getPath());
    }

    public FileOpener(String string) {
        super(string);
    }

    public String getText() {
        if (this.txt == null) {
            return null;
        }
        return this.txt.toString();
    }

    public void read(String string) throws IOException {
        byte[] byArray = null;
        FileInputStream fileInputStream = null;
        int n = 0;
        Object var5_5 = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        if (this.isFile()) {
            try {
                fileInputStream = new FileInputStream(this);
                this.bin = new ByteArrayOutputStream();
                byArray = new byte[1024];
                while ((n = fileInputStream.read(byArray)) != -1) {
                    this.bin.write(byArray, 0, n);
                }
                this.txt = new StringBuffer(new String(this.bin.toByteArray(), string));
                return;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setText(String string) {
        this.txt = new StringBuffer();
        if (string != null) {
            this.txt.append(string);
        }
    }

    public void write(String string) throws AlreadyFileLockException, IOException {
        LockableFileOutputStream lockableFileOutputStream = null;
        try {
            lockableFileOutputStream = new LockableFileOutputStream(new FileOutputStream(this));
            if (!lockableFileOutputStream.tryLock()) {
                throw new AlreadyFileLockException("The file has been already locked by other program.");
            }
            lockableFileOutputStream.write(this.getText().getBytes(string));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (lockableFileOutputStream != null) {
                lockableFileOutputStream.unlock();
                lockableFileOutputStream.flush();
                lockableFileOutputStream.close();
                lockableFileOutputStream = null;
            }
        }
    }
}

