package jp.oarts.pirka.test.view;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;

import javax.imageio.ImageIO;

import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.kernel.PirkaImage;
import jp.oarts.pirka.core.win.PirkaWindow;

public class CtrlTest04 extends PirkaWindow {

	public CtrlTest04() {
		FieldMap field = getFieldMap();

		// [v쐬
		int c = 0;
		for (int i = 0; i < 4; i++) {
			FieldMap newField = createLoopFieldMap("loop1");
			field.addFieldMap("loop1", newField);
	
			for (int j = 0; j < 5; j++) {
				FieldMap newField2 = createLoopFieldMap("loop2");
				newField.addFieldMap("loop2", newField2);

				newField2.setValue("button", "{^ " + i + "-" + j);
				if (((c++) % 2) == 0) {
					newField2.setOption("button", "style", "background-color: #c0f0c0");
				}
				newField2.setImage("imageButton", new ImageButton(i, j));
			}
		}
	}

	public void button() {
		FieldMap field = getFieldMap();

		int[] loopIndex = getActionLoopIndex();
		StringBuilder sb = new StringBuilder();
		sb.append("[ṽTu~bg{^");
		for (int i = 0; i < loopIndex.length; i++) {
			if (i > 0) {
				sb.append('-');
			}
			sb.append(loopIndex[i]);
		}
		sb.append("NbN܂");
		field.setValue("msg", sb.toString());

	}

	public void imageButton() {
		FieldMap field = getFieldMap();

		int[] loopIndex = getActionLoopIndex();
		StringBuilder sb = new StringBuilder();
		sb.append("[ṽC[W{^");
		for (int i = 0; i < loopIndex.length; i++) {
			if (i > 0) {
				sb.append('-');
			}
			sb.append(loopIndex[i]);
		}
		sb.append("NbN܂");
		field.setValue("msg", sb.toString());

	}

	public void execButton() {
		FieldMap field = getFieldMap();
		field.setValue("msg", "[vÕ{^NbN܂");
	}

	public void onElse() {
		FieldMap field = getFieldMap();
		field.setValue("msg", "`̃{^NbN܂");
	}

	public PirkaWindow returnButton() {
		return null;
	}

	class ImageButton extends PirkaImage {
		int xx;

		int yy;

		public ImageButton(int xx, int yy) {
			this.xx = xx;
			this.yy = yy;
		}

		public byte[] getImage() throws IOException {
			int width = 25;
			int height = 25;

			BufferedImage img = new BufferedImage(width, height, BufferedImage.TYPE_3BYTE_BGR);
			ByteArrayOutputStream baos = null;
			Graphics2D g = null;
			try {
				g = (Graphics2D) img.createGraphics();
				paint(g, width, height);
				baos = new ByteArrayOutputStream();
				ImageIO.write(img, "png", baos);
				baos.flush();

			} finally {
				if (g != null) {
					g.dispose();
					g = null;
				}
				img = null;
				if (baos != null) {
					baos.close();
				}
			}
			return baos.toByteArray();

		}

		private void paint(Graphics2D g2, int width, int height) {

			g2.setColor(new Color(0xff,0xd0,0xd0));
			g2.fillRect(0, 0, width, height);
			g2.setColor(new Color(0xd0,0xf0,0xd0));
			g2.fillRect(xx, yy, width - xx*2, height - yy*2);
			g2.setColor(new Color(0x80,0x80,0xff));
			g2.fillRect(xx*2, yy*2, width -  xx * 4, height  - yy * 4);
		}

		public String getMimeType() {
			return PirkaImage.MIME_TYPE_PNG;
		}

	}

}
