package jp.oarts.pirka.sample;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;

import jp.oarts.pirka.core.ajax.AjaxScript;
import jp.oarts.pirka.core.ajax.JavaScriptInnerHTML;
import jp.oarts.pirka.core.ajax.OnEventJavaScript;
import jp.oarts.pirka.core.ajax.RequestData;
import jp.oarts.pirka.core.ajax.ResponseData;
import jp.oarts.pirka.core.ajax.ResponseName;
import jp.oarts.pirka.core.analyzer.html.HtmlIncludeAnalyzer;
import jp.oarts.pirka.core.analyzer.html.HtmlTools;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.win.PirkaWindow;

public class Instruction extends PirkaWindow {

	private InstructionData instructionData;

	public Instruction(int selectNo, InstructionData instructionData) {

		this.instructionData = instructionData;
		final InstructionData data = instructionData;

		AjaxScript ajax = new AjaxScript() {
			@Override
			public ResponseData run(Map<String, String[]> param) {
				ResponseData responseData = new ResponseData();
				String[] names = param.get("name");
				if (names != null && names.length > 0) {
					String suffix = names[0];
					if (param.containsKey("open")) {
						int p = Integer.parseInt(suffix);
						if (p >= 0 && p < data.getSourceList().size()) {
							String fileName = data.getSourceList().get(p).getResourceFileName();
							responseData.put("src" + suffix, "<pre><code>" + HtmlTools.webStringWithSpace(getText(fileName)) + "</code></pre>", false, false);
						}
					} else if (param.containsKey("close")) {
						responseData.put("src" + suffix, "");
					}
				}
				data.getSourceList();
				return responseData;
			}
		};

		FieldMap field = getFieldMap();
		field.setAjaxScript("ajax", ajax);
		field.setValue("title", instructionData.getSampleName());
		field.setValue("gaiyou", instructionData.getGaiyou());
		field.setValue("point", getText("/jp/oarts/pirka/sample/point/" + instructionData.getPointFileName()));

		List<SourceData> list = instructionData.getSourceList();
		field.clearFieldMap("fileLoop");
		int index = 0;
		for (SourceData source : list) {
			FieldMap loopField = createLoopFieldMap("fileLoop");
			field.addFieldMap("fileLoop", loopField);
			loopField.setValue("fileName", source.getFileName());
			loopField.setValue("explanatory", source.getExplanatory());

			loopField.setOption("open", "onClick", OnEventJavaScript.getSource("ajax", true, new RequestData("name", "" + index), new RequestData("open", "")));
			loopField.setOption("close", "onClick", OnEventJavaScript.getSource("ajax", true, new RequestData("name", "" + index), new RequestData("close", "")));
			ajax.addResScript(new JavaScriptInnerHTML("src$" + (index), new ResponseName("src" + (index))));
			index++;
		}
		
		if(instructionData.getSampleClass()==null){
			field.setOption("execButton", "disabled");
		}else{
			field.clearOption("execButton", "disabled");
		}

	}

	public PirkaWindow execButton() {
		try {
			if(instructionData.getSampleClass()!=null){
				return (PirkaWindow) instructionData.getSampleClass().newInstance();
			}
		} catch (InstantiationException e) {
		} catch (IllegalAccessException e) {
		}
		return this;
	}

	public PirkaWindow returnButton1() {
		return null;
	}

	public PirkaWindow returnButton2() {
		return null;
	}

	private String getText(String fileName) {

		String file = fileName;

		String text = "";
		byte[] buffer = new byte[4096];
		BufferedInputStream bis = null;
		ByteArrayOutputStream baos = null;
		try {
			try {
				URL url = HtmlIncludeAnalyzer.class.getResource(file);
				if (url == null) {
					throw new IOException("\[Xt@C܂ file=" + file);
				}
				bis = new BufferedInputStream(url.openStream());
				baos = new ByteArrayOutputStream();

				while (true) {
					int length = bis.read(buffer);
					if (length <= 0) {
						break;
					}
					baos.write(buffer, 0, length);
				}
				baos.flush();
				return new String(baos.toByteArray(), "JISAutoDetect");
			} finally {
				if (baos != null) {
					baos.close();
				}
				if (bis != null) {
					bis.close();
				}
			}
		} catch (IOException e) {
			text = "...";
		}

		return text;
	}
}
