/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.util.check;

import java.io.Serializable;
import jp.oarts.pirka.core.util.check.Checker;
import jp.oarts.pirka.core.util.check.PirkaCheckException;
import jp.oarts.pirka.core.util.check.message.PirkaStandardMessage;
import jp.oarts.pirka.core.util.format.PirkaFormatUtil;

public class PirkaChecker
implements Serializable {
    private static final long serialVersionUID = -9175743954494137540L;
    public static final Checker required = new Checker(){

        public void check(String value) throws PirkaCheckException {
            if (value == null || value.length() <= 0) {
                throw new PirkaCheckException(PirkaStandardMessage.REQUIRED_ERROR, new String[0]);
            }
        }
    };
    public static final Checker intValue = new Checker(){

        public void check(String value) throws PirkaCheckException {
            if (value.length() > 0 && PirkaFormatUtil.parseInteger(value) == null) {
                throw new PirkaCheckException(PirkaStandardMessage.INT_VALUE_ERROR, new String[0]);
            }
        }
    };
    public static final Checker longValue = new Checker(){

        public void check(String value) throws PirkaCheckException {
            if (value.length() > 0 && PirkaFormatUtil.parseLong(value) == null) {
                throw new PirkaCheckException(PirkaStandardMessage.LONG_VALUE_ERROR, new String[0]);
            }
        }
    };
    public static final Checker numeric = new Checker(){

        public void check(String value) throws PirkaCheckException {
            if (value.length() > 0 && PirkaFormatUtil.parseBigDecimal(value) == null) {
                throw new PirkaCheckException(PirkaStandardMessage.NUMERIC_ERROR, new String[0]);
            }
        }
    };
    public static final Checker date = new Checker(){

        public void check(String value) throws PirkaCheckException {
            if (value.length() > 0 && PirkaFormatUtil.parseDate(value) == null) {
                throw new PirkaCheckException(PirkaStandardMessage.DATE_ERROR, new String[0]);
            }
        }
    };
    public static final Checker time = new Checker(){

        public void check(String value) throws PirkaCheckException {
            if (value.length() > 0 && PirkaFormatUtil.parseTime(value) == null) {
                throw new PirkaCheckException(PirkaStandardMessage.TIME_ERROR, new String[0]);
            }
        }
    };
    public static final Checker datetime = new Checker(){

        public void check(String value) throws PirkaCheckException {
            if (value.length() > 0 && PirkaFormatUtil.parseTimestamp(value) == null) {
                throw new PirkaCheckException(PirkaStandardMessage.DATETIME_ERROR, new String[0]);
            }
        }
    };
    public static final Checker sqlInjection = new Checker(){

        public void check(String value) throws PirkaCheckException {
            if (value.length() > 0) {
                int i = 0;
                while (i < value.length()) {
                    if (" +,=\"'|;\\".indexOf(value.charAt(i)) >= 0) {
                        throw new PirkaCheckException(PirkaStandardMessage.CHARACTER_ERROR, new String[0]);
                    }
                    ++i;
                }
            }
        }
    };

    public static boolean checkString(String string, String ... existStrings) {
        int length = string.length();
        int i = 0;
        while (i < length) {
            char c = string.charAt(i);
            boolean flg = false;
            String[] stringArray = existStrings;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String existString = stringArray[n];
                if (existString.indexOf(c) >= 0) {
                    flg = true;
                    break;
                }
                ++n;
            }
            if (!flg) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNumber(String string) {
        return PirkaChecker.checkString(string, "0123456789");
    }
}

