/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.kernel;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.oarts.pirka.core.err.ErrorMessageManagerIF;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.HtmlPartsType;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.kernel.PirkaInfoPool;
import jp.oarts.pirka.core.kernel.PirkaThreadMap;
import jp.oarts.pirka.core.util.converter.StringConverter;
import jp.oarts.pirka.core.util.field.FieldItem;
import jp.oarts.pirka.core.win.PirkaWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PirkaMakeHtml
implements Serializable {
    public static String makeHtml(PirkaWindow window, ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker) throws IOException {
        List<HtmlParts> list = PirkaInfoPool.getHtmlPartsList(window.getHtmlFileName());
        if (list == null) {
            throw new RuntimeException("\u30a8\u30e9\u30fc");
        }
        StringConverter stringConverter = PirkaThreadMap.getEntryPointObjct().getOutputStringConverter();
        StringBuilder sb = new StringBuilder();
        HashMap<String, Object> workMap = new HashMap<String, Object>();
        PirkaMakeHtml.makeHtmlMain(sb, list, window.getFieldMap(), "", window.getWindowBaseData(), errorMessageManager, errorMessageStocker, workMap, stringConverter);
        return sb.toString();
    }

    private static void makeHtmlMain(StringBuilder sb, List<HtmlParts> htmlPartsLis, FieldMap map, String suffix, WindowBaseData windowBaseData, ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker, Map<String, Object> workMap, StringConverter stringConverter) throws IOException {
        for (HtmlParts parts : htmlPartsLis) {
            if (parts.getType() != HtmlPartsType.TAG) {
                sb.append(parts.getOrgString());
                continue;
            }
            String name = parts.getName();
            if (name == null || name.length() <= 0) {
                sb.append(parts.getOrgString());
                if (parts.getChild() == null) continue;
                PirkaMakeHtml.makeHtmlMain(sb, parts.getChild(), map, suffix, windowBaseData, errorMessageManager, errorMessageStocker, workMap, stringConverter);
                sb.append(parts.getEndTag());
                continue;
            }
            FieldItem fieldItem = map.getFieldItem(name);
            HtmlCtrlParts ctrl = fieldItem.getCtrl();
            if (ctrl == null) {
                throw new RuntimeException("HTML\u3068\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb\u30de\u30c3\u30d7\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3000" + name);
            }
            if (ctrl.getCtrlProcesser().isLoop()) {
                PirkaMakeHtml.makeHtmlLoop(sb, parts, fieldItem, map, suffix, windowBaseData, errorMessageManager, errorMessageStocker, workMap, stringConverter);
                continue;
            }
            if (ctrl.getCtrlProcesser().isSwitch()) {
                PirkaMakeHtml.makeHtmlSwitch(sb, parts, fieldItem, map, suffix, windowBaseData, errorMessageManager, errorMessageStocker, workMap, stringConverter);
                continue;
            }
            PirkaMakeHtml.makeHtmlTag(sb, parts, fieldItem, map, suffix, windowBaseData, errorMessageManager, errorMessageStocker, workMap, stringConverter);
        }
    }

    private static void makeHtmlTag(StringBuilder sb, HtmlParts parts, FieldItem fieldItem, FieldMap map, String suffix, WindowBaseData windowBaseData, ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker, Map<String, Object> workMap, StringConverter stringConverter) throws IOException {
        HtmlCtrlParts ctrl = fieldItem.getCtrl();
        String value = null;
        Object obj = PirkaMakeHtml.getValue(map, ctrl.getName());
        if (obj != null) {
            value = obj.toString();
        }
        if (value != null) {
            value = stringConverter.convert(value);
        }
        if (ctrl.getCtrlProcesser().isFormatCtrl() && ctrl.getFormat() != null) {
            String formatedValue = ctrl.getFormat().format(value);
            if (formatedValue != null) {
                sb.append(ctrl.getCtrlProcesser().makeStartTag(ctrl, suffix, formatedValue, fieldItem.isChecked(), windowBaseData, errorMessageManager, errorMessageStocker, fieldItem.isErrorFlag(), workMap));
            } else {
                sb.append(ctrl.getCtrlProcesser().makeStartTag(ctrl, suffix, value, fieldItem.isChecked(), windowBaseData, errorMessageManager, errorMessageStocker, fieldItem.isErrorFlag(), workMap));
            }
        } else {
            sb.append(ctrl.getCtrlProcesser().makeStartTag(ctrl, suffix, value, fieldItem.isChecked(), windowBaseData, errorMessageManager, errorMessageStocker, fieldItem.isErrorFlag(), workMap));
        }
        if (!ctrl.getCtrlProcesser().isUseChild() && parts.getChild() != null) {
            PirkaMakeHtml.makeHtmlMain(sb, parts.getChild(), map, suffix, windowBaseData, errorMessageManager, errorMessageStocker, workMap, stringConverter);
        }
        if (parts.getChild() != null) {
            sb.append(ctrl.getCtrlProcesser().makeEndTag(ctrl));
        }
    }

    private static void makeHtmlLoop(StringBuilder sb, HtmlParts parts, FieldItem fieldItem, FieldMap map, String suffix, WindowBaseData windowBaseData, ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker, Map<String, Object> workMap, StringConverter stringConverter) throws IOException {
        Object loopObject;
        HtmlCtrlParts ctrl = fieldItem.getCtrl();
        sb.append(ctrl.getCtrlProcesser().makeStartTag(ctrl, suffix, "", false, windowBaseData, errorMessageManager, errorMessageStocker, fieldItem.isErrorFlag(), workMap));
        if (!ctrl.getCtrlProcesser().isUseChild() && parts.getChild() != null && (loopObject = PirkaMakeHtml.getValue(map, ctrl.getName())) != null) {
            if (loopObject instanceof List) {
                List valueList = (List)loopObject;
                int i = 0;
                while (i < valueList.size()) {
                    PirkaMakeHtml.makeHtmlMain(sb, parts.getChild(), (FieldMap)valueList.get(i), String.valueOf(suffix) + '$' + i, windowBaseData, errorMessageManager, errorMessageStocker, workMap, stringConverter);
                    ++i;
                }
            } else if (loopObject instanceof Integer) {
                int loopCount = (Integer)loopObject;
                int i = 0;
                while (i < loopCount) {
                    PirkaMakeHtml.makeHtmlMain(sb, parts.getChild(), map, String.valueOf(suffix) + '$' + i, windowBaseData, errorMessageManager, errorMessageStocker, workMap, stringConverter);
                    ++i;
                }
            }
        }
        if (parts.getChild() != null) {
            sb.append(ctrl.getCtrlProcesser().makeEndTag(ctrl));
        }
    }

    private static void makeHtmlSwitch(StringBuilder sb, HtmlParts parts, FieldItem fieldItem, FieldMap map, String suffix, WindowBaseData windowBaseData, ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker, Map<String, Object> workMap, StringConverter stringConverter) throws IOException {
        HtmlCtrlParts ctrl = fieldItem.getCtrl();
        sb.append(ctrl.getCtrlProcesser().makeStartTag(ctrl, suffix, "", false, windowBaseData, errorMessageManager, errorMessageStocker, fieldItem.isErrorFlag(), workMap));
        if (!ctrl.getCtrlProcesser().isUseChild() && parts.getChild() != null) {
            boolean switchFlag = false;
            Object object = PirkaMakeHtml.getValue(map, ctrl.getName());
            if (object instanceof Boolean) {
                switchFlag = (Boolean)object;
            }
            if (switchFlag) {
                PirkaMakeHtml.makeHtmlMain(sb, parts.getChild(), map, suffix, windowBaseData, errorMessageManager, errorMessageStocker, workMap, stringConverter);
            }
        }
        if (parts.getChild() != null) {
            sb.append(ctrl.getCtrlProcesser().makeEndTag(ctrl));
        }
    }

    private static Object getValue(FieldMap map, String name) {
        FieldItem fieldItem = null;
        fieldItem = map.getFieldItem(name);
        if (fieldItem == null) {
            return null;
        }
        return fieldItem.getValue();
    }
}

