/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.analyzer.html;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.List;
import jp.oarts.pirka.core.analyzer.html.HtmlFieldMapAnalyzer;
import jp.oarts.pirka.core.analyzer.html.HtmlIncludeAnalyzer;
import jp.oarts.pirka.core.analyzer.html.HtmlMockupAnalyzer;
import jp.oarts.pirka.core.analyzer.html.HtmlSplitAnalyzer;
import jp.oarts.pirka.core.app.OfflineEntryPoint;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.field.FieldItem;

public class HtmlToolAnalyzer
implements Serializable {
    private static final long serialVersionUID = 55986138998965783L;

    public static FieldMap getFieldMap(File htmlFile) throws IOException {
        FieldMap fieldMap = null;
        List<HtmlParts> htmlPartsList = null;
        StringReader sr = null;
        try {
            String html = HtmlIncludeAnalyzer.include(htmlFile);
            sr = new StringReader(html);
            htmlPartsList = HtmlSplitAnalyzer.getHtmlParts(sr);
            htmlPartsList = HtmlMockupAnalyzer.cutMockup(htmlPartsList);
            sr.close();
            sr = null;
            FieldMap fieldMap2 = fieldMap = HtmlFieldMapAnalyzer.getFieldMap(htmlPartsList, OfflineEntryPoint.getInstance().getCtrlProcesserMap());
            return fieldMap2;
        }
        finally {
            if (sr != null) {
                sr.close();
            }
        }
    }

    public static void main(String[] args) {
        try {
            FieldMap fieldMap = HtmlToolAnalyzer.getFieldMap(new File(args[0]));
            HtmlToolAnalyzer.print(fieldMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void print(FieldMap fieldMap) {
        String[] fieldNames;
        if (fieldMap == null) {
            return;
        }
        String[] stringArray = fieldNames = fieldMap.getFieldNames();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String fieldName = stringArray[n];
            FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
            HtmlCtrlParts ctrlParts = fieldItem.getCtrl();
            CtrlProcesser ctrlProcesser = ctrlParts.getCtrlProcesser();
            System.out.print(fieldName);
            System.out.print(" : tag=");
            System.out.print(ctrlParts.getTagName());
            System.out.print(" : type=");
            System.out.print(ctrlParts.getTypeOption());
            System.out.print(" : \u30eb\u30fc\u30d7\u968e\u5c64=");
            System.out.print(fieldItem.getLoopDeepLevel());
            System.out.print(" : \u5165\u529b=");
            System.out.print(ctrlProcesser.isInputCtrl());
            System.out.print(" : \u30c1\u30a7\u30c3\u30af\u30bf\u30a4\u30d7=");
            System.out.print(ctrlProcesser.isCheckCtrl());
            System.out.print(" : \u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9=");
            System.out.print(ctrlProcesser.isActionCtrl());
            System.out.print(" : \u30eb\u30fc\u30d7=");
            System.out.print(ctrlProcesser.isLoop());
            System.out.println();
            if (ctrlProcesser.isLoop() && fieldItem.getValue() != null && fieldItem.getValue() instanceof List) {
                List list = (List)fieldItem.getValue();
                for (FieldMap childMap : list) {
                    HtmlToolAnalyzer.print(childMap);
                }
            }
            ++n;
        }
    }
}

