package jp.oarts.pirka.core.util.converter;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import jp.oarts.pirka.core.util.format.PirkaFormatUtil;

/**
 * `ς݂̃f[^Ro[^[
 * 
 * @author ito
 * 
 */
public enum DataConverterDefined implements DataConverter {

	/** Ro[^[ */
	STRING(new DataConverter() {
		public Object win2Target(Object windowFieldData) {
			return windowFieldData == null ? "" : windowFieldData.toString();
		}

		public Object target2Win(Object targetData) {
			return targetData == null ? "" : targetData.toString();
		}

	}),

	/** IntegerRo[^[ */
	INTEGER(new DataConverter() {
		public Object win2Target(Object windowFieldData) {
			if (windowFieldData instanceof String) {
				return PirkaFormatUtil.parseInteger((String) windowFieldData);
			}
			return null;
		}

		public Object target2Win(Object targetData) {
			if (targetData instanceof Integer) {
				return targetData.toString();
			}

			return "";
		}

	}),

	/** LongRo[^[ */
	LONG(new DataConverter() {
		public Object win2Target(Object windowFieldData) {
			if (windowFieldData instanceof String) {
				return PirkaFormatUtil.parseLong((String) windowFieldData);
			}
			return null;
		}

		public Object target2Win(Object targetData) {
			if (targetData instanceof Long) {
				return targetData.toString();
			}

			return "";
		}

	}),

	/** tRo[^ */
	DATE(new DataConverter() {
		public Object win2Target(Object windowFieldData) {
			if (windowFieldData instanceof String) {
				return PirkaFormatUtil.parseDate((String) windowFieldData);
			}
			return null;
		}

		public Object target2Win(Object targetData) {
			if (targetData instanceof Date) {
				SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
				return sdf.format((String) targetData);
			}

			return "";
		}

	}),

	/** ԃRo[^[ */
	TIME(new DataConverter() {
		public Object win2Target(Object windowFieldData) {
			if (windowFieldData instanceof String) {
				return PirkaFormatUtil.parseTime((String) windowFieldData);
			}
			return null;
		}

		public Object target2Win(Object targetData) {
			if (targetData instanceof Time) {
				SimpleDateFormat sdf = new SimpleDateFormat("HHmmss");
				return sdf.format((String) targetData);
			}

			return "";
		}

	}),

	/** tԃRo[^[ */
	TIMESTAMP(new DataConverter() {
		public Object win2Target(Object windowFieldData) {
			if (windowFieldData instanceof String) {
				return PirkaFormatUtil.parseTimestamp((String) windowFieldData);
			}
			return null;
		}

		public Object target2Win(Object targetData) {
			if (targetData instanceof Timestamp) {
				SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd HHmmss");
				return sdf.format((String) targetData);
			}

			return "";
		}

	}),

	/** rbOfV}Ro[^[ */
	BIGDECIMAL(new DataConverter() {
		public Object win2Target(Object windowFieldData) {
			if (windowFieldData instanceof String) {
				return PirkaFormatUtil.parseBigDecimal((String) windowFieldData);
			}
			return null;
		}

		public Object target2Win(Object targetData) {
			if (targetData instanceof BigDecimal) {
				return targetData.toString();
			}

			return "";
		}

	}),

	;

	/** f[^Ro[^IuWFNg */
	private DataConverter dataConverter;

	/**
	 * RXgN^
	 */
	private DataConverterDefined(DataConverter dataConverter) {
		this.dataConverter = dataConverter;
	}

	/**
	 * ʂœ͂ꂽf[^DTO܂BeanɊi[IuWFNgɕϊ܂B
	 * 
	 * @param windowFieldData
	 *            ʂœ͂ꂽ񖔂BooleanIuWFNgf[^
	 * @return ϊꂽIuWFNg
	 */
	public Object win2Target(Object windowFieldData) {
		return dataConverter.win2Target(windowFieldData);
	}

	/**
	 * DTOBeanɊi[ĂIuWFNgʏ̕f[^ɕϊ܂B
	 * 
	 * @param targetData
	 *            ^[QbgɊi[ĂIuWFNg
	 * @return ʏ̕܂́ABooleanIuWFNgf[^
	 */
	public Object target2Win(Object targetData) {
		return dataConverter.target2Win(targetData);
	}
}