package jp.oarts.pirka.core.util.check;

import java.io.Serializable;
import java.util.Map;

import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.field.FieldItem;

public class AutoCheck  implements Serializable{

	int errorCount;

	private boolean isReturn;

	public AutoCheck() {
		errorCount = 0;
		isReturn = false;
	}

	public boolean isReturn() {
		return isReturn;
	}

	public int runCheck(CheckerStocker checkerStocker, Map<String, FieldItem> rootFieldMap, FieldMap fieldMap,ErrorMessageStocker errorMessageStocker) {

		for (int i = 0; i < checkerStocker.size(); i++) {
			CheckerItem checkerItem = checkerStocker.getCheckItem(i);

			if (checkerItem.getMode() == CheckerItem.MODE_CHECKER) {

				for (String fieldName : rootFieldMap.keySet()) {

					String baseFieldName = fieldName;
					int index = fieldName.indexOf('$');
					if (index >= 0) {
						baseFieldName = fieldName.substring(0, index);
					}

					// `FbNΏۃtB[hmF
					if (baseFieldName.equals(checkerItem.getFieldName())) {
						FieldItem fieldItem = rootFieldMap.get(fieldName);
						String value = (String) fieldItem.getValue();

						try {
							for (Checker checker : checkerItem.getCheckers()) {
								checker.check((String) value);
							}
						} catch (PirkaCheckException e) {
							errorCount++;
							fieldItem.setErrorFlag(true);
							// G[bZ[Wǉ
							if (checkerItem.getPrikaMessage() == null) {
								if (checkerItem.getErrorMessage() == null || checkerItem.getErrorMessage().length() <= 0) {
									errorMessageStocker.addError(fieldItem.getCtrl().getOfficialFieldName(), e.getMessage());
								} else {
									errorMessageStocker.addError(fieldItem.getCtrl().getOfficialFieldName(), checkerItem.getErrorMessage());
								}
							} else {
								errorMessageStocker.addError(fieldItem.getCtrl().getOfficialFieldName(), checkerItem.getPrikaMessage());
							}
						}

					}
				}
			} else if (checkerItem.getMode() == CheckerItem.MODE_CHECK_AND_TELLER) {
				for (CheckAndTeller checkAndTeller : checkerItem.getCheckAndTellers()) {
					checkAndTeller.setFieldMap(fieldMap);
					checkAndTeller.setErrorMessageStocker(errorMessageStocker);
					if (!checkAndTeller.check()) {
						errorCount++;
					}
				}
			} else if (checkerItem.getMode() == CheckerItem.MODE_BREAKER) {
				if (errorCount > 0) {
					return errorCount;
				}
			} else if (checkerItem.getMode() == CheckerItem.MODE_RETURNER) {
				if (errorCount > 0) {
					isReturn = true;
					return errorCount;
				}
			}

		}
		return errorCount;
	}
}
