package jp.oarts.pirka.core.general;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;

import jp.oarts.pirka.core.ajax.AjaxScript;
import jp.oarts.pirka.core.ctrl.SelectList;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.kernel.PirkaImage;
import jp.oarts.pirka.core.util.format.FieldFormat;

/**
 * tB[hƂ̃Rg[
 * 
 * @author ito
 * 
 */
public class HtmlCtrlParts  implements Serializable{

	/** O */
	private String name;

	/** x[X */
	private String baseName;

	/** TtBbNX */
	private String suffixName;

	/** ^O */
	private String tagName;

	/** ^Cv */
	private String typeOption;

	/** l */
	private Object defaultValue;

	/** }bv ɂ̓^Cv(type)Ɩ(name)͊i[Ȃ */
	private Map<String, String> optionMap;

	/** I^OKvtO */
	private boolean endTagFlag;

	/** ꗗXg */
	private SelectList selectList;

	/**	AjaxXNvg	*/
	private	AjaxScript ajaxScript;

	/** tH[}bg */
	private FieldFormat format;

	/** WEB Safe [htO */
	private boolean webSafe;

	/** O[vx */
	private int groupLevel;

	/** TtBbNXttO */
	private boolean suffix;

	/** C[WIuWFNg */
	private PirkaImage image;

	/** `FbN */
	private boolean autoCheck;

	/**  */
	private String officialFieldName;

	/** ^O̗LtO false=^OWJȂ */
	private boolean tagEffective;

	/** Rg[[vZbT[ */
	private CtrlProcesser ctrlProcesser;

	/** Tu~bgw */
	private boolean submitFlag;

	/** Tu~bgFORM */
	private String formName;

	/**
	 * RXgN^
	 */
	public HtmlCtrlParts(String tagName, Map<String, String> optionMap, boolean endTagFlag) {
		this();

		this.tagName = tagName;
		this.optionMap = new TreeMap<String, String>();
		for (String optionName : optionMap.keySet()) {

			if (optionName.equalsIgnoreCase("name")) {
				name = optionMap.get(optionName);
				officialFieldName = name;
			} else if (optionName.equalsIgnoreCase("type")) {
				typeOption = optionMap.get(optionName);
			} else if (optionName.equalsIgnoreCase("value")) {
				defaultValue = optionMap.get(optionName);
			} else {
				this.optionMap.put(optionName, optionMap.get(optionName));
			}
		}
		this.endTagFlag = endTagFlag;

		int index = name.indexOf('$');
		if (index > 0) {
			baseName = name.substring(0, index);
			suffixName = name.substring(index);
		} else {
			baseName = name;
			suffixName = "";
		}

	}

	/**
	 * RXgN^
	 */
	private HtmlCtrlParts() {
		this.name = "";
		this.baseName = "";
		this.suffixName = "";
		this.tagName = "";
		this.typeOption = "";
		this.optionMap = new TreeMap<String, String>();
		this.defaultValue = null;
		this.endTagFlag = false;
		this.selectList = null;
		this.format = null;
		this.webSafe = true;
		this.groupLevel = 0;
		this.suffix = true;
		this.image = null;
		this.autoCheck = true;
		this.officialFieldName = "";
		this.tagEffective = true;
		this.ctrlProcesser = null;
		// this.innerBlockEffective = true;
		
		this.ajaxScript=null;
	}

	/**
	 * @\߂܂B
	 * 
	 * @return @\
	 */
	public String getProcesserNmae() {
		if (typeOption == null || typeOption.length() <= 0) {
			return tagName;
		}
		return tagName + "#" + typeOption.toLowerCase();
	}

	/**
	 * N[
	 * 
	 * @return ̃IuWFNg̃N[Ԃ
	 */
	public Object clone() {

		HtmlCtrlParts object = new HtmlCtrlParts();

		object.name = name;
		object.baseName = baseName;
		object.suffixName = suffixName;
		object.tagName = tagName;
		object.typeOption = typeOption;
		object.optionMap = new TreeMap<String, String>();
		object.optionMap.putAll(optionMap);
		object.defaultValue = defaultValue;
		object.endTagFlag = endTagFlag;
		if (selectList != null) {
			object.selectList = (SelectList) selectList.clone();
		} else {
			object.selectList = null;
		}
		object.format = format;
		object.webSafe = webSafe;
		object.groupLevel = groupLevel;
		object.suffix = suffix;
		object.image = image;
		object.autoCheck = autoCheck;
		object.officialFieldName = officialFieldName;
		object.tagEffective = tagEffective;
		object.ctrlProcesser = ctrlProcesser;

		return object;
	}

	/**
	 * @return autoCheck ߂܂B
	 */
	public boolean isAutoCheck() {
		return autoCheck;
	}

	/**
	 * @param autoCheck
	 *            ݒ肷 autoCheckB
	 */
	public void setAutoCheck(boolean autoCheck) {
		this.autoCheck = autoCheck;
	}

	/**
	 * @return format ߂܂B
	 */
	public FieldFormat getFormat() {
		return format;
	}

	/**
	 * @param format
	 *            ݒ肷 formatB
	 */
	public void setFormat(FieldFormat format) {
		this.format = format;
	}

	/**
	 * @return groupLevel ߂܂B
	 */
	public int getGroupLevel() {
		return groupLevel;
	}

	/**
	 * @param groupLevel
	 *            ݒ肷 groupLevelB
	 */
	public void setGroupLevel(int groupLevel) {
		this.groupLevel = groupLevel;
	}

	/**
	 * @return image ߂܂B
	 */
	public PirkaImage getImage() {
		return image;
	}

	/**
	 * @param image
	 *            ݒ肷 imageB
	 */
	public void setImage(PirkaImage image) {
		this.image = image;
	}

	/**
	 * @return officialFieldName ߂܂B
	 */
	public String getOfficialFieldName() {
		return officialFieldName;
	}

	/**
	 * @param officialFieldName
	 *            ݒ肷 officialFieldNameB
	 */
	public void setOfficialFieldName(String officialFieldName) {
		this.officialFieldName = officialFieldName;
	}

	/**
	 * @return optionMap ߂܂B
	 */
	public Map<String, String> getOptionMap() {
		return optionMap;
	}

	/**
	 * @param optionMap
	 *            ݒ肷 optionMapB
	 */
	public void setOptionMap(Map<String, String> optionMap) {
		this.optionMap = optionMap;
	}

	/**
	 * @return selectList ߂܂B
	 */
	public SelectList getSelectList() {
		return selectList;
	}

	/**
	 * @param selectList
	 *            ݒ肷 selectListB
	 */
	public void setSelectList(SelectList selectList) {
		this.selectList = selectList;
	}

	/**
	 * @return suffix ߂܂B
	 */
	public boolean isSuffix() {
		return suffix;
	}

	/**
	 * @param suffix
	 *            ݒ肷 suffixB
	 */
	public void setSuffix(boolean suffix) {
		this.suffix = suffix;
	}

	/**
	 * @return webSafe ߂܂B
	 */
	public boolean isWebSafe() {
		return webSafe;
	}

	/**
	 * @param webSafe
	 *            ݒ肷 webSafeB
	 */
	public void setWebSafe(boolean webSafe) {
		this.webSafe = webSafe;
	}

	/**
	 * @return name ߂܂B
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return tagName ߂܂B
	 */
	public String getTagName() {
		return tagName;
	}

	/**
	 * @return typeOption ߂܂B
	 */
	public String getTypeOption() {
		return typeOption;
	}

	/**
	 * @return defaultValue ߂܂B
	 */
	public Object getDefaultValue() {
		return defaultValue;
	}

	/**
	 * @param defaultValue
	 *            ݒ肷 defaultValueB
	 */
	public void setDefaultValue(Object defaultValue) {
		this.defaultValue = defaultValue;
	}

	// /**
	// * @return innerBlockEffective ߂܂B
	// */
	// public boolean isInnerBlockEffective() {
	// return innerBlockEffective;
	// }
	//
	// /**
	// * @param innerBlockEffective
	// * ݒ肷 innerBlockEffectiveB
	// */
	// public void setInnerBlockEffective(boolean innerBlockEffective) {
	// this.innerBlockEffective = innerBlockEffective;
	// }
	//
	/**
	 * @return tagEffective ߂܂B
	 */
	public boolean isTagEffective() {
		return tagEffective;
	}

	/**
	 * @param tagEffective
	 *            ݒ肷 tagEffectiveB
	 */
	public void setTagEffective(boolean tagEffective) {
		this.tagEffective = tagEffective;
	}

	/**
	 * @return endTagFlag ߂܂B
	 */
	public boolean isEndTagFlag() {
		return endTagFlag;
	}

	/**
	 * @return baseName ߂܂B
	 */
	public String getBaseName() {
		return baseName;
	}

	/**
	 * @return ajaxScript ߂܂B
	 */
	public AjaxScript getAjaxScript() {
		return ajaxScript;
	}

	/**
	 * @param ajaxScript ݒ肷 ajaxScriptB
	 */
	public void setAjaxScript(AjaxScript ajaxScript) {
		this.ajaxScript = ajaxScript;
	}

	/**
	 * @return suffixName ߂܂B
	 */
	public String getSuffixName() {
		return suffixName;
	}

	/**
	 * @return ctrlProcesser ߂܂B
	 */
	public CtrlProcesser getCtrlProcesser() {
		return ctrlProcesser;
	}

	/**
	 * @param ctrlProcesser
	 *            ݒ肷 ctrlProcesserB
	 */
	public void setCtrlProcesser(CtrlProcesser ctrlProcesser) {
		this.ctrlProcesser = ctrlProcesser;
	}

	/**
	 * @return formName ߂܂B
	 */
	public String getFormName() {
		return formName;
	}

	/**
	 * @param formName ݒ肷 formNameB
	 */
	public void setFormName(String formName) {
		this.formName = formName;
	}

	/**
	 * @return submitFlag ߂܂B
	 */
	public boolean isSubmitFlag() {
		return submitFlag;
	}

	/**
	 * @param submitFlag ݒ肷 submitFlagB
	 */
	public void setSubmitFlag(boolean submitFlag) {
		this.submitFlag = submitFlag;
	}

}
