package jp.oarts.pirka.core.ctrl.proc.def;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.text.StringContent;

import jp.oarts.pirka.core.analyzer.html.HtmlTools;
import jp.oarts.pirka.core.app.EntryPointIF;
import jp.oarts.pirka.core.ctrl.SelectList;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.err.ErrorMessageManagerIF;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.HtmlPartsType;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.kernel.PirkaThreadMap;
import jp.oarts.pirka.core.util.converter.StringConverter;
import jp.oarts.pirka.core.util.field.FieldItem;

/**
 * SELECT^OvZbT[
 * 
 * @author ito
 * 
 */
public class SelectProcesser extends CtrlProcesser {

	/**
	 * HTMLp[cXg̎^O̎qp[c̃^O鎞trueԂ
	 * 
	 * @return true=qp[c̃^O
	 */
	@Override
	public boolean isUseChild() {
		return true;
	}

	/**
	 * [v^O̎tureԂ
	 * 
	 * @return true=[v^O
	 */
	@Override
	public boolean isLoop() {
		return false;
	}

	/**
	 * XCb`^O̎tureԂ
	 * 
	 * @return true=XCb`^O
	 */
	public boolean isSwitch() {
		return false;
	}

	/**
	 * uEUœ͂sȂ^ÔƂrtueԂ
	 * 
	 * @return true=uEUœ
	 */
	@Override
	public boolean isInputCtrl() {
		return true;
	}

	/**
	 * uEU[̃ANVƂtureԂ
	 * 
	 * @return true=ANV
	 */
	@Override
	public boolean isActionCtrl() {
		return false;
	}

	/**
	 * O[sOsȂ^OiWI{^Ȃǁj̊evf̎tureԂ
	 * 
	 * @return true=O[sOvf
	 */
	public boolean isGroupItem() {
		return false;
	}

	/**
	 * `FbNsȂRg[̎tureԂ
	 * 
	 * @return true=`FbNsȂRg[
	 */
	public boolean isCheckCtrl() {
		return false;
	}

	/**
	 * tH[}bg\ȃRg[̎tureԂ
	 * 
	 * @return true=tH[}bg\ȃRg[
	 */
	public boolean isFormatCtrl() {
		return false;
	}

	/**
	 * f[^̃ZbgsȂ
	 * 
	 * @param data
	 */
	public void setValue(Object data, FieldItem fieldItem) {
		if (data == null || (!(data instanceof String[]) && !(data instanceof String))) {
			throw new RuntimeException("w肳ꂽl̓Zbgł܂ StringIuWFNgString[]IuWFNgZbgĂ");
		}

		fieldItem.setValue((String) data);
	}

	/**
	 * l͂
	 * 
	 * @param ctrl
	 *            Rg[
	 * @param list
	 *            ̃^OHTMLp[c̃Xg
	 */
	@Override
	public void analyzeInitValue(HtmlCtrlParts ctrl, List<HtmlParts> list) {

		// List<String> selectedList=new ArrayList<String>();
		StringBuilder defaultValueSb = new StringBuilder();

		SelectList selectList = new SelectList();
		for (HtmlParts parts : list) {
			if (parts.getType() == HtmlPartsType.TAG) {
				if ("option".equalsIgnoreCase(parts.getTagName())) {
					String sendValue = parts.getOption().get("value");
					boolean selected = parts.getOption().containsKey("selected");
					String optionValue = "";
					if (parts.getChild() != null) {
						optionValue = HtmlTools.toSimpleString(parts.getChild()); // ꕶΉ
					}
					if (sendValue == null || sendValue.length() <= 0) {
						selectList.add(optionValue);
						if (selected) {
							if (defaultValueSb.length() > 0) {
								defaultValueSb.append('\t');
							}
							defaultValueSb.append(optionValue);
						}
					} else {
						selectList.add(optionValue, sendValue);
						if (selected) {
							if (defaultValueSb.length() > 0) {
								defaultValueSb.append('\t');
							}
							defaultValueSb.append(sendValue);
						}
					}
				}
			}
		}
		ctrl.setSelectList(selectList);
		ctrl.setDefaultValue(defaultValueSb.toString());
	}

	/**
	 * ^O쐬
	 * 
	 * @param ctrl
	 *            Rg[p[c
	 * @param loopSuffix
	 *            [vTtBbNX
	 * @param value
	 *            l
	 * @param checked
	 *            `FbNl
	 * @param windowBaseData
	 *            ʃf[^
	 * @param errorMessageManager
	 *            G[bZ[W}l[W[
	 * @param errorMessageStocker
	 *            G[bZ[WXgbJ[
	 * @param errorFlag
	 *            G[tO true=G[
	 * @param workMap
	 *            Ɨp}bv
	 * 
	 * @return 쐬ꂽ^O
	 */
	public String makeStartTag(HtmlCtrlParts ctrl, String loopSuffix, String value, boolean checked, WindowBaseData windowBaseData, //
			ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker, boolean errorFlag, Map<String, Object> workMap) {

		Map<String, String> optionMap = ctrl.getOptionMap();
		if (errorFlag) {
			optionMap = changeStyle(errorMessageManager.getNgStyle(), optionMap);
		}
		Map<String, String> selectedMap = makeSelectedMap(value);
		StringBuilder sb = new StringBuilder();

		sb.append('<');
		sb.append(ctrl.getTagName());
		sb.append(createOptionString(ctrl.getTypeOption(), ctrl.getName() + loopSuffix, loopSuffix, value, ctrl.isSuffix(), optionMap));
		sb.append(">");

		StringConverter stringContent = PirkaThreadMap.getEntryPointObjct().getOutputStringConverter();
		SelectList selectList = ctrl.getSelectList();
		if (selectList != null) {
			for (int i = 0; i < selectList.size(); i++) {
				sb.append("<option value=\"");
				sb.append(stringContent.convert(selectList.getSendValue(i)));
				sb.append('\"');
				if (selectedMap.containsKey(stringContent.convert(selectList.getSendValue(i)))) {	
					sb.append(" selected");
				}
				sb.append('>');
				sb.append(HtmlTools.webString(stringContent.convert(selectList.getOptionValue(i))));
				sb.append("</option>");
				sb.append("\r\n");
			}

		}
		return sb.toString();
	}

	/**
	 * I}bv쐬
	 * 
	 * @param value
	 * @return I}bv
	 */
	private Map<String, String> makeSelectedMap(String value) {
		Map<String, String> rtnMap = new HashMap<String, String>();
		if (value != null) {
			String[] values = value.split("\\t");
			for (String selectValue : values) {
				rtnMap.put(selectValue, selectValue);
			}
		}
		return rtnMap;
	}

	/**
	 * NGXgi͌ʁjtB[hɃZbg
	 * 
	 * @param reqMap
	 *            NGXg}bv
	 * @param fieldName
	 *            TtBbNXttB[h
	 * @param fieldItem
	 *            tB[h
	 * @param values
	 *            l
	 */
	@Override
	public void setReq(Map<String, String[]> reqMap, String fieldName, FieldItem fieldItem, String[] values) {

		StringBuilder defaultValueSb = new StringBuilder();
		if (values != null) {
			for (String value : values) {
				if (defaultValueSb.length() > 0) {
					defaultValueSb.append('\t');
				}
				defaultValueSb.append(value);

			}
			fieldItem.setValue(defaultValueSb.toString());
		}
	}

}
