package jp.oarts.pirka.core.ajax;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;


/**
 * AjaxXNvg
 */
public abstract class AjaxScript implements Serializable {

	/** ĂяoOɎsJavaScriptXg */
	private List<JavaScript> preScriptList = new LinkedList<JavaScript>();

	/** ĂяoɎsJavaScriptXg */
	private List<JavaScript> resScriptList = new LinkedList<JavaScript>();

	/** ĂяoG[ɎsJavaScriptXg */
	private List<JavaScript> errScriptList = new LinkedList<JavaScript>();

	/**
	 * Ajax̌ĂяoJn
	 * 
	 * @param param
	 *            p[^
	 * @return ^[f[^}bviL[FږAf[^Flj
	 */
	public abstract ResponseData run(Map<String, String[]> param);


	/**
	 * AjaxĂяoOɎsJavascript擾
	 * 
	 * @return Javascript\[X
	 */
	public String getPreScript() {
		StringBuilder sb = new StringBuilder();
		for (JavaScript javaScript : preScriptList) {
			sb.append(javaScript.getScript());
			sb.append("\n");
		}
		return sb.toString();
	}

	/**
	 * AjaxĂяoOɎsJavascriptSč폜
	 */
	public void clearPreScript() {
		preScriptList.clear();
	}

	/**
	 * AjaxĂяoOɎsJavascript\[XɐVȍsǉ
	 * 
	 * @param javaScripts
	 *            JavaScriptIuWFNg
	 */
	public void addPreScript(JavaScript... javaScripts) {
		for (JavaScript javaScript : javaScripts) {
			preScriptList.add(javaScript);
		}
	}

	/**
	 * AjaxĂяoăX|X󂯎ɎsJavascript擾
	 * 
	 * @return Javascript\[X
	 */
	public String getResScript() {
		StringBuilder sb = new StringBuilder();
		for (JavaScript javaScript : resScriptList) {
			sb.append(javaScript.getScript());
			sb.append("\n");
		}
		return sb.toString();
	}

	/**
	 * AjaxĂяoăX|X󂯎ɎsJavascriptSč폜
	 */
	public void clearResScript() {
		resScriptList.clear();
	}

	/**
	 * AjaxĂяoăX|X󂯎ɎsJavascript\[XɐVȍsǉ
	 * 
	 * @param javaScripts
	 *            JavaScriptIuWFNg
	 */
	public void addResScript(JavaScript... javaScripts) {
		for (JavaScript javaScript : javaScripts) {
			resScriptList.add(javaScript);
		}
	}

	/**
	 * AjaxĂяoG[ƂȂƂɎsJavascript擾
	 * 
	 * @return Javascript\[X
	 */
	public String getErrScript() {
		StringBuilder sb = new StringBuilder();
		for (JavaScript javaScript : errScriptList) {
			sb.append(javaScript.getScript());
			sb.append("\n");
		}
		return sb.toString();
	}

	/**
	 * AjaxĂяoG[ƂȂƂɎsJavascriptSč폜
	 */
	public void clearErrScript() {
		errScriptList.clear();
	}

	/**
	 * AjaxĂяoG[ƂȂƂɎsJavascript\[XɐVȍsǉ
	 * 
	 * @param javaScripts
	 *            JavaScriptIuWFNg
	 */
	public void addErrScript(JavaScript... javaScripts) {
		for (JavaScript javaScript : javaScripts) {
			errScriptList.add(javaScript);
		}
	}

}
