<?php
	/**
	* View and manipulate account records using SQL
	* @author Kazuya Nouchi <kazuya@mail.popcom.jp>
	* @copyright Copyright (C) 2000-2004 Free Software Foundation, Inc. http://www.fsf.org/
	* @license http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public License
	* @package phpgwapi
	* @subpackage accounts_db
	* @version $Id: class.accounts_db.inc.php,v 1.1.8.1 2004/09/27 22:00:45 kazuyan Exp $
	*/

	/**
	* View and manipulate handling user and group account records using SQL
	*
	* @package setup
	* @subpackage accounts_db
	*/
	class accounts_db extends accounts_
	{
		function accounts_db($account_id = '', $account_type = '')
		{
			$this->accounts_($account_id, $account_type);
		}

		function create($account_info,$default_prefs=True)
		{
			if($this->account_type=='u')
			{
				$account_info['person_id'] = $this->save_contact_for_account($account_info);
			}
			if(!isset($account_info['person_id']) || $account_info['person_id']=='')
			{
				$account_info['person_id']='NULL';
			}
			
			$this->db->query('INSERT INTO phpgw_accounts (account_lid, account_type, account_pwd,'
							. 'account_firstname, account_lastname, account_status, account_expires,'
							. 'person_id,account_quota) '
							. "VALUES ('" . $this->db->db_addslashes($account_info['account_lid']) . "',"
							. "'" . $this->db->db_addslashes($account_info['account_type']) . "',"
							. "'" . md5($account_info['account_passwd']) . "',"
							. "'" . $this->db->db_addslashes($account_info['account_firstname']) . "',"
							. "'" . $this->db->db_addslashes($account_info['account_lastname']) . "',"
							. "'" . $this->db->db_addslashes($account_info['account_status']) . "',"
							. intval($account_info['account_expires']) . ',' . intval($account_info['person_id'])
							. ',' . intval($account_info['quota']) . ')',__LINE__,__FILE__);

			$accountid = $this->db->get_last_insert_id('phpgw_accounts','account_id');
			if($accountid && is_object($GLOBALS['phpgw']->preferences) && $default_prefs)
			{
				$GLOBALS['phpgw']->preferences->create_defaults($accountid);
			}
			if($this->account_type=='u')
			{
				$contacts = CreateObject('phpgwapi.contacts', False);
				$contacts->edit_contact($account_info['person_id'], array('owner' => $accountid));
			}
			return $accountid;
		}

		function exists($account_lid) // imho this should take $id, $lid as args
		{
			static $by_id, $by_lid;

			$sql = 'SELECT count(account_id) FROM phpgw_accounts WHERE ';
			if(is_integer($account_lid))
			{
				if(@isset($by_id[$account_lid]) && $by_id[$account_lid] != '')
				{
					return $by_id[$account_lid];
				}
				$sql .= 'account_id=' . intval($account_lid);
			}
			else
			{
				if(@isset($by_lid[$account_lid]) && $by_lid[$account_lid] != '')
				{
					return $by_lid[$account_lid];
				}
				$sql .= "account_lid = '" . $this->db->db_addslashes($account_lid) . "'";
			}

			$this->db->query($sql,__LINE__,__FILE__);
			$this->db->next_record();
			$ret_val = $this->db->f(0) > 0;
			if(is_integer($account_lid))
			{
				$by_id[$account_lid] = $ret_val;
				$by_lid[$this->id2name($account_lid)] = $ret_val;
			}
			else
			{
				$by_lid[$account_lid] = $ret_val;
				$by_id[$this->name2id($account_lid)] = $ret_val;
			}
			return $ret_val;
		}
		
		function name2id($account_lid)
		{
			static $name_list;

			if (! $account_lid)
			{
				return False;
			}

			if($name_list[$account_lid] && $name_list[$account_lid] != '')
			{
				return $name_list[$account_lid];
			}

			$account_lid = $this->db->db_addslashes($account_lid);

			$this->db->query('SELECT account_id FROM phpgw_accounts '
				. " WHERE account_lid='" . $account_lid . "'",__LINE__,__FILE__);
			if($this->db->num_rows())
			{
				$this->db->next_record();
				$name_list[$account_lid] = intval($this->db->f('account_id'));
			}
			else
			{
				$name_list[$account_lid] = False;
			}
			return $name_list[$account_lid];
		}

		function id2name($account_id)
		{
			static $id_list;

			if (! $account_id)
			{
				return False;
			}

			if($id_list[$account_id])
			{
				return $id_list[$account_id];
			}

			$this->db->query('SELECT account_lid FROM phpgw_accounts WHERE account_id=' . intval($account_id),__LINE__,__FILE__);
			if($this->db->num_rows())
			{
				$this->db->next_record();
				$id_list[$account_id] = $this->db->f('account_lid');
			}
			else
			{
				$id_list[$account_id] = False;
			}
			return $id_list[$account_id];
		}
		
		function delete($accountid = '')
		{
			$account_id = get_account_id($accountid);

			/* Do this last since we are depending upon this record to get the account_lid above */
			$tables_array = Array('phpgw_accounts');
			$this->db->lock($tables_array);
			$this->db->query('DELETE FROM phpgw_accounts WHERE account_id=' . $account_id);
			$this->db->unlock();
		}
	}
?>