<?php
	/**************************************************************************\
	* phpGroupWare - Registration                                              *
	* http://www.phpgroupware.org                                              *
	* This application written by Joseph Engo <jengo@phpgroupware.org>         *
	* --------------------------------------------                             *
	* Funding for this program was provided by http://www.checkwithmom.com     *
	* --------------------------------------------                             *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/

	/* $Id: main.php,v 1.1.1.2.8.1 2004/09/27 21:42:03 kazuyan Exp $ */

	/*
	** This program is non-standard, we will create and manage our sessions manually.
	** We don't want users to be kicked out half way through, and we really don't need a true
	** session for it.
	*/

	$GLOBALS['sessionid'] = $_REQUEST['sessionid'];
	$GLOBALS['kp3']       = $_REQUEST['kp3'];

	// Note: This is current not a drop in install, it requires some manual installation
	//       Take a look at the README file
	$domain         = 'default';
	$template_set   = 'default';

	if ($_GET['menuaction'])
	{
		list($app,$class,$method) = explode('.',$_GET['menuaction']);
		if (! $app || ! $class || ! $method)
		{
			$invaild_data = True;
		}
	}
	else
	{
		$app = 'registration';
		$invaild_data = True;
	}

	$phpgw_info['flags'] = array(
		'noheader'   => True,
		'nonavbar'   => True,
		'noapi'      => True,
		'currentapp' => $app
	);
	include('../header.inc.php');
	include(PHPGW_API_INC . '/common_functions.inc.php');

	/*!
		@function print_debug
		@abstract print debug data only when debugging mode is turned on.
		@author jengo
		@discussion This function is used for debugging data. 
		@syntax print_debug('message');
		@example print_debug('this is some debugging data');
	*/
	function print_debug($text='',$var='',$part='APP',$level='notused')
	{
		if ((strtoupper($part) == 'APP' && DEBUG_APP == True) || (strtoupper($part) == 'API' && DEBUG_API == True))
		{
			if ($var == '')
			{
				echo "debug: $text <br>\n";
			}
			else
			{
				echo "$text: $var<br>\n";
			}			
		}
	}

	/*!
	@function lang
	@abstract function to deal with multilanguage support
	*/
	function lang($key, $m1='', $m2='', $m3='', $m4='', $m5='', $m6='', $m7='', $m8='', $m9='', $m10='') 
	{
		global $phpgw;
		$vars  = array($m1,$m2,$m3,$m4,$m5,$m6,$m7,$m8,$m9,$m10);
		$value = $phpgw->translation->translate($key,$vars);
		return $value;
	}

	$phpgw_info['server']           = $phpgw_domain[$domain];
	$GLOBALS['phpgw']               = createobject('phpgwapi.phpgw');
	$GLOBALS['phpgw']->db           = createobject('phpgwapi.db');
	$GLOBALS['phpgw']->db->Host     = $phpgw_info['server']['db_host'];
	$GLOBALS['phpgw']->db->Type     = $phpgw_info['server']['db_type'];
	$GLOBALS['phpgw']->db->Database = $phpgw_info['server']['db_name'];
	$GLOBALS['phpgw']->db->User     = $phpgw_info['server']['db_user'];
	$GLOBALS['phpgw']->db->Password = $phpgw_info['server']['db_pass'];

	/* Fill phpgw_info["server"] array */
	$GLOBALS['phpgw']->db->query("select * from phpgw_config WHERE config_app='phpgwapi'",__LINE__,__FILE__);
	while ($GLOBALS['phpgw']->db->next_record())
	{
		$phpgw_info['server'][$GLOBALS['phpgw']->db->f('config_name')] = stripslashes($GLOBALS['phpgw']->db->f('config_value'));
	}
	$phpgw_info['server']['template_set'] = $template_set;

	$GLOBALS['phpgw']->common        = createobject('phpgwapi.common');
	$GLOBALS['phpgw']->auth          = createobject('phpgwapi.auth');
	$GLOBALS['phpgw']->accounts      = createobject('phpgwapi.accounts');
	$GLOBALS['phpgw']->acl           = createobject('phpgwapi.acl');
	$GLOBALS['phpgw']->preferences   = createobject('phpgwapi.preferences');
	$GLOBALS['phpgw']->applications  = createobject('phpgwapi.applications');
	$GLOBALS['phpgw']->hooks         = createobject('phpgwapi.hooks');
	$GLOBALS['phpgw']->session       = createobject('phpgwapi.sessions');

	$GLOBALS['phpgw']->common->key  = md5($GLOBALS['kp3'] . $GLOBALS['sessionid'] . $phpgw_info['server']['encryptkey']);
	$GLOBALS['phpgw']->common->iv   = $phpgw_info['server']['mcrypt_iv'];

	$cryptovars[0] = $GLOBALS['phpgw']->common->key;
	$cryptovars[1] = $GLOBALS['phpgw']->common->iv;
	$GLOBALS['phpgw']->crypto = createobject('phpgwapi.crypto', $cryptovars);

	define('PHPGW_APP_ROOT', $GLOBALS['phpgw']->common->get_app_dir());
	define('PHPGW_APP_INC', $GLOBALS['phpgw']->common->get_inc_dir());
	define('PHPGW_APP_TPL', $GLOBALS['phpgw']->common->get_tpl_dir());
	define('PHPGW_IMAGES', $GLOBALS['phpgw']->common->get_image_path());
	define('PHPGW_IMAGES_DIR', $GLOBALS['phpgw']->common->get_image_dir());

	$GLOBALS['phpgw']->template      = createobject('phpgwapi.Template',PHPGW_APP_TPL);
	$GLOBALS['phpgw']->translation   = createobject('phpgwapi.translation');

	$c = createobject('phpgwapi.config','registration');
	$c->read_repository();
	$config = $c->config_data;

	if (! $GLOBALS['sessionid'])
	{
		$GLOBALS['sessionid'] = $GLOBALS['phpgw']->session->create($config['anonymous_user'] . '@' . $domain,$config['anonymous_pass'],'text');
		$GLOBALS['kp3']       = $GLOBALS['phpgw']->session->kp3;
	}

	if (! $GLOBALS['phpgw']->session->verify($GLOBALS['sessionid'],$GLOBALS['kp3']))
	{
		// Lets hope this works
		$GLOBALS['sessionid'] = $GLOBALS['phpgw']->session->create($config['anonymous_user'] . '@' . $domain,$config['anonymous_pass'],'text');

		if (! $GLOBALS['sessionid'])
		{
			echo '<center><b>Attempted to create an anonymous session 2 times and failed</b></center>';
			$GLOBALS['phpgw']->common->phpgw_exit();
		}
	}

	if ($app && $class)
	{
		$obj = createobject(sprintf('%s.%s',$app,$class));

		if ((is_array($obj->public_functions) && $obj->public_functions[$method]) && ! $invalid_data)
		{
			eval("\$obj->$method();");
		}
	}
	else
	{
		$_obj = createobject('registration.uireg');
		$_obj->step1();
	}
