<?php
	/**
	* Log message
	* @author ?
	* @copyright Copyright (C) ? ?
	* @copyright Portions Copyright (C) 2004 Free Software Foundation, Inc. http://www.fsf.org/
	* @license http://www.fsf.org/licenses/gpl.html GNU General Public License
	* @package phpgwapi
	* @subpackage application
	* @version $Id: class.log_message.inc.php,v 1.1.1.1 2004/04/06 23:11:23 kazuyan Exp $
	*/

	/**
	* Log message
	* 
	* @package phpgwapi
	* @subpackage application
	*/
	class log_message
	{
		/***************************\
		*	Instance Variables...   *
		\***************************/
		var $severity = 'E';
		var $msg  = 'Unknown error';
		var $timestamp;
		var $fname = '';
		var $line = 0;
		var $app = '';

		var $public_functions = array();

		function log_message($parms)
		{
			if ($parms == '')
			{
				return;
			}
			$etext = $parms['text'];
			$parray = Array();
			for($counter=1;$counter<=10;$counter++)
			{
				// This used to support p_1, etc, but it was not used anywhere.
				// More efficient to standardize on one way.
				$str = 'p'.$counter;
				if(isset($parms[$str]) && !empty($parms[$str]))
				{
					$parray[$counter] = $parms[$str];
				}
			}

			// This code is left in for backward compatibility with the 
			// old log code.  Consider it deprecated.
			if (eregi('([DIWEF])-([[:alnum:]]*)\, (.*)',$etext,$match))
			{
				$this->severity = strtoupper($match[1]);
				$this->msg      = trim($match[3]);
			}
			else
			{
				$this->msg = trim($etext);
			}
			
			// If I was going to use translations for log messages, I'd probably put it here.
			
			// DWD - override the severity in the message with that provided in the parms. 
			// Eventually, the old logging will go away and the above code can be removed.
			if ( $parms['severity'] ) 
			{
				$this->severity=$parms['severity'];
			}

			@reset($parray);
			while( list($key,$val) = each( $parray ) )
			{
				// Experimental code using print_r on parameters.   Don't know if I'll keep this.  DWD
				// Make it configurable?
				if ( version_compare(phpversion(), "4.3.0", ">=") )
				{
					$val = print_r($val, true);
				}
				$this->msg = preg_replace( "/%$key/", "'".$val."'", $this->msg );
			}
			@reset($parray);

			$this->timestamp = time();
			
			if ( isset($parms['line']) ) 
			{
				$this->line  = $parms['line'];
			}
			if ( isset($parms['file']) ) 
			{
				// DWD - May want to change the "remove the server root" thing to a configuration option
				$this->fname = substr($parms['file'], strlen(PHPGW_SERVER_ROOT) + 1);
			}			
			if  ( isset( $GLOBALS['phpgw_info']['flags']['currentapp']) ) 
			{
				$this->app = $GLOBALS['phpgw_info']['flags']['currentapp'];
			}
		}
	}
