<?php
	/**
	* jsColorPicker wrapper-class
	*
	* @author Kazuya Nouchi <phpgwjp@mail.popcom.jp>
	* @copyright Copyright (C) 2003,2004 Free Software Foundation, Inc. http://www.fsf.org/
	* @license http://www.fsf.org/licenses/gpl.html GNU General Public License
	* @package phpgwapi
	* @subpackage gui
	* @version $Id: class.jscolorpicker.inc.php,v 1.1.8.1 2004/09/27 10:06:57 kazuyan Exp $
	*/
	class jscolorpicker
	{
		/*!
		@function jscolorpicker
		@syntax jscolorpicker( type='' )
		@author Kazuya Nouchi
		@abstract constructor of the class
		@param $type Type of Color Picker Popup('window' or '') 
		*/
		function jscolorpicker($type='')
		{
			if (!is_object($GLOBALS['phpgw']->js))
				$GLOBALS['phpgw']->js = createObject('phpgwapi.javascript');
			$this->phpgw_js_url = $GLOBALS['phpgw_info']['server']['webserver_url'].'/phpgwapi/js';
			$valid1 = $GLOBALS['phpgw']->js->validate_file('colorpicker', 'PopupWindow');
			$valid2 = $GLOBALS['phpgw']->js->validate_file('colorpicker', 'AnchorPosition');
			$this->type = $type == 'window' ? "'$type'" : '';
			if ($valid1 && $valid2)
			{
				$GLOBALS['phpgw_info']['flags']['java_script'] .= "\n"
					. '<script type="text/javascript" src="'
					. $GLOBALS['phpgw']->link('/phpgwapi/js/colorpicker/ColorPicker2.js')
					."\">\n</script>\n";
				$this->phpgw_js_valid = True;
			}
		}
		/*!
		@function input
		@syntax input( $input_name,$form='document.forms[0]',$value='',$options='',$need_sharp=false )
		@author Kazuya Nouchi
		@abstract creates an inputfield for the jscolorpocker (returns the necessary html and js)
		@param $input_name name and id of the input-field (it also names the id of the img $input_name.'_img')
		@param $form Form to which the input-field belongs
		@param $value web-safe RGB Color(216 colors)
		@param $options options of the input-field
		@param $need_sharp Is # added to the input field or not?
		*/		
		function input($input_name, $form='document.forms[0]', $value='', $options='', $need_sharp=False)
		{
			$sharp = $need_sharp ? '' : '#';
			if (!empty($value) && substr($value, 0, 1) != '#')
				$init_value = '#' . $value;
			$html_out = $sharp.'<input type="text" id="'.$input_name.'" name="'.$input_name.'" size="20" value="'.$value.'" '.$options.'/>'."\n";
			if ($this->phpgw_js_valid)
			{
				if ($need_sharp)
					$color_set = "ColorPicker_targetInput.value = color;";
				else
					$color_set = "ColorPicker_targetInput.value = color.substring(1, 7);";
				$var_name = preg_replace('/[\[\]\#]/', '', $input_name);
				$err_msg = lang("Target Input is null, which means you either didn\'t use the \'select\' function or you have no defined your own \'pickColor\' function to handle the picked color!");
				$html_out .= "&nbsp;<img id=\"${var_name}_img\" name=\"${var_name}_img\" src=\"".$GLOBALS['phpgw']->common->find_image('phpgwapi','colorpicker').'" title="'.lang('Select Color').'" style="cursor:pointer; cursor:hand;" onclick=\''."colorpicker_${var_name}.select(${form}.elements[\"${input_name}\"],\"${var_name}_img\"); return false;".'\' align="center">'."\n";
				//$html_out .= "&nbsp;<img id=\"${var_name}_img\" name=\"${var_name}_img\" src=\"".$GLOBALS['phpgw']->common->find_image('phpgwapi','colorpicker').'" title="'.lang('Select Color').'" style="cursor:pointer; cursor:hand;" onclick="'."colorpicker_${var_name}.select(${form}('${input_name}'),'${var_name}_img'); return false;".'" align="center">'."\n";
				$html_out .= '<script type="text/javascript">'."\n".
					"var colorpicker_${var_name} = new ColorPicker($this->type);\n".
					//"colorpicker_${var_name}.currentValue=\"$init_value\";\n".
					"colorpicker_${var_name}.writeDiv();\n". 
					//"document.writeln('<img id=\"$input_name\" name=\"$input_name\" src=\"".$GLOBALS['phpgw']->common->find_image('phpgwapi','colorpicker').'" title="'.lang('Select Color').'" style="cursor:pointer; cursor:hand;" onclick="'."colorpicker_${input_name}.select(${form}.${input_name},\'${input_name}\'); return false;".'"/>'."');\n".
					"function pickColor(color) {\n".
					"\tif (ColorPicker_targetInput==null) {\n".
					"\t\talert(\"$err_msg\");\n".
					"\t\treturn;\n".
					"\t}\n".
					"\t$color_set\n".
					"}\n".
					"</script>\n";
			}
			return $html_out;
		}	
	}
?>