<?php
  /**************************************************************************\
  * phpGroupWare - phpgw_dj                                                  *
  * http://www.phpgroupware.org                                              *
  * Written by Miles Lott <milosch@phpgroupware.org>                         *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: import.php,v 1.1.1.1.18.1 2004/09/26 10:51:04 kazuyan Exp $ */

	$GLOBALS['phpgw_info']['flags'] = array(
		'currentapp'           => 'dj',
		'enable_browser_class' => True
	);
	include('../header.inc.php');

	$sep = SEP;

	function _debug($s)
	{
		if ($GLOBALS['debug'])
		{
		 	echo '<br>' . $s;
		}
	}

	if (!$HTTP_POST_VARS['convert'])
	{
		$GLOBALS['phpgw']->template->set_file(array('import' => 'import.tpl'));

		$GLOBALS['phpgw']->template->set_var('lang_cancel',lang('Cancel'));
		$GLOBALS['phpgw']->template->set_var('lang_cat',lang('Select Category'));
		$GLOBALS['phpgw']->template->set_var('cancel_url',$GLOBALS['phpgw']->link('/dj/index.php'));
		$GLOBALS['phpgw']->template->set_var('navbar_bg',$GLOBALS['phpgw_info']['theme']['navbar_bg']);
		$GLOBALS['phpgw']->template->set_var('navbar_text',$GLOBALS['phpgw_info']['theme']['navbar_text']);
		$GLOBALS['phpgw']->template->set_var('import_text',lang('import file list'));
		$GLOBALS['phpgw']->template->set_var('action_url',$GLOBALS['phpgw']->link('/dj/import.php'));
		$GLOBALS['phpgw']->template->set_var('tsvfilename','');
		$GLOBALS['phpgw']->template->set_var('conv',$GLOBALS['conv']);
		$GLOBALS['phpgw']->template->set_var('debug',lang('Debug output in browser'));
		$GLOBALS['phpgw']->template->set_var('download',lang('Submit'));
		/*
		$GLOBALS['phpgw']->template->set_var('start',$GLOBALS['start']);
		$GLOBALS['phpgw']->template->set_var('sort',$GLOBALS['sort']);
		$GLOBALS['phpgw']->template->set_var('order',$GLOBALS['order']);
		$GLOBALS['phpgw']->template->set_var('filter',$GLOBALS['filter']);
		$GLOBALS['phpgw']->template->set_var('query',$GLOBALS['query']);
		$GLOBALS['phpgw']->template->set_var('cat_id',$GLOBALS['cat_id']);
		*/
		$GLOBALS['phpgw']->template->set_var('lang_create_list',lang('Create a list of your mp3s (e.g. find /mp3dir -name *.mp3 > mp3_list)'));
		$GLOBALS['phpgw']->template->set_var('lang_file_path',lang('Enter the path to the exported file here:'));
		$GLOBALS['phpgw']->template->set_var('lang_mark_mp3',lang('Mark imported MP3s as unavaiable'));
		$GLOBALS['phpgw']->template->pparse('out','import');
		$GLOBALS['phpgw']->common->phpgw_footer();
	}
	else
	{
		$cats = CreateObject('phpgwapi.categories');
		$fp = fopen($HTTP_POST_VARS['tsvfile'],'r');
		$num = 0;
		while ($data = fgets($fp,8000))
		{
			$buffer .= $data;
			$mp3info = get_info($data);

			$mp3info->title = $mp3info->name;

			if (!$mp3info->title)
			{
				$ta = explode('/',$data);
				$_title = $ta[count($ta)-1];
				$_title = ereg_replace('.mp3','',$_title);
				$_title = ereg_replace('.MP3','',$_title);
				$_title = urldecode($_title);
				$mp3info->title = $_title;
				unset($ta);
				unset($title);
			}

			$mp3info->descr = $mp3info->genre .' (#'. $mp3info->genreno .')';

			_debug('genre: -' . $mp3info->genre . '-');
			if ($mp3info->genre)
			{
				if (! $cats->exists('mains',$mp3info->genre))
				{
					/* $cats->add($mp3info->genre,0,$mp3info->descr,'','public',''); */
					$cats->add(array(
						'name'   => $mp3info->genre,
						'descr'  => $mp3info->descr,
						'access' => 'public',
						'data'   => ''
					));
				}
			}

			_debug('name: '  . $mp3info->name);
			_debug('title: ' . $mp3info->title);
			_debug('data:'   . $data . '<p>');

			add_song($mp3info);

			$num++;
		}

		fclose($fp);

		if ($debug)
		{
			echo "<pre>$buffer</pre>";
			echo '<a href="'.$GLOBALS['phpgw']->link('/dj/index.php',
				"sort=$sort&order=$order&filter=$filter&start=$start&query=$query&cat_id=$cat_id")
				. '">'.lang("OK").'</a>';
			$GLOBALS['phpgw']->common->phpgw_footer();
		}
		else
		{
			echo '<a href="'.$GLOBALS['phpgw']->link('/dj/index.php',
				"sort=$sort&order=$order&filter=$filter&start=$start&query=$query&cat_id=$cat_id")
				. '">'.lang("OK").'</a>';
			//echo "<br>" . lang('Successfully imported %1 records',$num);
			if($num)
			{
				echo "<br>".lang('Successfully imported %1 records', $num)."\n";
			}
			else
			{
				echo "<br>".lang('No new files')."\n";
			}

			$GLOBALS['phpgw']->common->phpgw_footer();
		}
	}
?>
