<?php
	class bocatalog_contact_comm_descr
	{
		function bocatalog_contact_comm_descr()
		{
			$this->so = CreateObject('addressbook.socatalog_contact_comm_descr');
			$this->standard_comm_type = array(
				'email'			=> lang('email'),
				'phone'			=> lang('phone'),
				'mobile phone'	=> lang('mobile phone'),
				'fax'			=> lang('fax'),
				'instant messaging'	=> lang('instant messaging'),
				'url'			=> lang('url'),
				'other'			=> lang('other')
			);
			$this->standard_comm_descr = array(
				'home email'	=> lang('home email'),
				'work email'	=> lang('work email'),
				'home phone'	=> lang('home phone'),
				'work phone'	=> lang('work phone'),
				'voice phone'	=> lang('voice phone'),
				'msg phone'		=> lang('msg phone'),
				'pager'			=> lang('pager'),
				'bbs'			=> lang('bbs'),
				'modem'			=> lang('modem'),
				'isdn'			=> lang('isdn'),
				'video'			=> lang('video'),
				'home fax'		=> lang('home fax'),
				'work fax'		=> lang('work fax'),
				'mobile (cell) phone'	=> lang('mobile (cell) phone'),
				'car phone'		=> lang('car phone'),
				'msn'			=> lang('msn'),
				'aim'			=> lang('aim'),
				'yahoo'			=> lang('yahoo'),
				'jabber'		=> lang('jabber'),
				'icq'			=> lang('icq'),
				'website'		=> lang('website')
			);
		}
		
		function select_catalog()
		{
			$comm_descr = $this->so->select_catalog();
			foreach($comm_descr as $key => $value)
			{
				$comm_descr_array[] = array('comm_type_id' => $value['comm_type'],
							    'comm_type'	=> $this->search_comm_type_id($value['comm_type']),
							    'comm_descr_id' => $value['comm_descr_id'],
							    'not_'.lang('edit').'_mode'	=> (isset($this->standard_comm_descr[$value['comm_description']])) ? True : False,
							    'not_'.lang('delete').'_mode'	=> (isset($this->standard_comm_descr[$value['comm_description']])) ? True : False,
							    'comm_description' => (isset($this->standard_comm_descr[$value['comm_description']])) ? $this->standard_comm_descr[$value['comm_description']] : $value['comm_description']);
			}
			return $comm_descr_array;
		}
		
		function insert($fields)
		{
			return $this->so->insert($fields);
		}
		
		function delete($key)
		{
			return $this->so->delete($key);
		}
		
		function update($key, $fields)
		{
			$this->so->update($key, $fields);
		}

		function get_record($key)
		{
			return $this->so->get_record($key);
		}

		function select_catalog_types()
		{
			$this->comm_type = $this->so->select_catalog_types();
			foreach ($this->comm_type as $idx => $val)
			{
				if (isset($this->standard_comm_type[$val['comm_type_description']]))
					$this->comm_type[$idx]['comm_type_description'] = $this->standard_comm_type[$val['comm_type_description']];
			}
			return $this->comm_type;
		}

		/**
		* Search communication type id in communications catalog
		*
		* @param integer $id The communication id to find
		* @return string The description type of id
		*/
		function search_comm_type_id($id)
		{
			return $this->search_catalog('comm_type_id', $id, 'comm_type_description', 'comm_type');
		}
		
		/**
		* Search communication type in location catalog
		*
		* @param string $description The communication type to find
		* @return integer The id of description
		*/
		function search_comm_type($description)
		{
			return $this->search_catalog('comm_type_description', $description, 'comm_type_id', 'comm_type');
		}

		/**
		* Search a value into an array
		*
		* @param string $field_to_search Field into what you want to find
		* @param string $value_to_search Value what you want
		* @param string $field Field what you want return
		* @param string $catalog Catalog name into you want to find
		* @return string The value which you requiere in $field
		*/
		function search_catalog($field_to_search, $value_to_search, $field, $catalog)
		{
			reset($this->$catalog);
			foreach ($this->$catalog as $key => $value)
			{
				if ($value[$field_to_search] == $value_to_search)
				{
					return $value[$field];
				}
			}
		}
	}
?>
