/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.media.jai.PlanarImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.explorer.ObservableEvent;
import org.weasis.core.api.explorer.model.DataExplorerModel;
import org.weasis.core.api.media.data.MediaElement;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.SeriesEvent;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.api.util.FileUtil;
import org.weasis.dicom.codec.DicomImageElement;
import org.weasis.dicom.codec.DicomMediaIO;
import org.weasis.dicom.codec.DicomSpecialElement;
import org.weasis.dicom.codec.Messages;
import org.weasis.dicom.codec.SortSeriesStack;

public class DicomSeries
extends Series<DicomImageElement> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DicomSeries.class);
    private static volatile PreloadingTask preloadingTask;

    public DicomSeries(String subseriesInstanceUID) {
        this(TagW.SubseriesInstanceUID, subseriesInstanceUID, null);
    }

    public DicomSeries(TagW displayTag, String subseriesInstanceUID, List<DicomImageElement> c) {
        super(TagW.SubseriesInstanceUID, (Object)subseriesInstanceUID, displayTag, c);
    }

    public String toString() {
        return (String)this.getTagValue(TagW.SubseriesInstanceUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] getImageInMemoryList() {
        boolean[] list;
        List list2 = this.medias;
        synchronized (list2) {
            list = new boolean[this.medias.size()];
            for (int i = 0; i < this.medias.size(); ++i) {
                if (!((DicomImageElement)((Object)this.medias.get(i))).isImageInCache()) continue;
                list[i] = true;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMedia(MediaElement media) {
        if (media != null && media.getMediaReader() instanceof DicomMediaIO) {
            DicomMediaIO dicomImageLoader = (DicomMediaIO)media.getMediaReader();
            if (media instanceof DicomImageElement) {
                int insertIndex;
                List list = this.medias;
                synchronized (list) {
                    int index = Collections.binarySearch(this.medias, (DicomImageElement)media, SortSeriesStack.instanceNumber);
                    insertIndex = index < 0 ? -(index + 1) : index + 1;
                    if (insertIndex < 0 || insertIndex > this.size()) {
                        insertIndex = this.medias.size();
                    }
                    this.medias.add(insertIndex, (DicomImageElement)media);
                }
                DataExplorerModel model = (DataExplorerModel)this.getTagValue(TagW.ExplorerModel);
                if (model != null) {
                    model.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Add, (Object)model, null, (Object)new SeriesEvent(SeriesEvent.Action.AddImage, (Object)this, (Object)insertIndex)));
                }
            } else if (media instanceof DicomSpecialElement) {
                this.setTag(TagW.DicomSpecialElement, media);
            }
        }
    }

    public String getToolTips() {
        StringBuffer toolTips = new StringBuffer();
        toolTips.append("<html>");
        this.addToolTipsElement(toolTips, Messages.getString("DicomSeries.pat"), TagW.PatientName);
        this.addToolTipsElement(toolTips, Messages.getString("DicomSeries.mod"), TagW.Modality);
        this.addToolTipsElement(toolTips, Messages.getString("DicomSeries.series_nb"), TagW.SeriesNumber);
        this.addToolTipsElement(toolTips, Messages.getString("DicomSeries.study"), TagW.StudyDescription);
        this.addToolTipsElement(toolTips, Messages.getString("DicomSeries.series"), TagW.SeriesDescription);
        String date = TagW.formatDate((Date)((Date)this.getTagValue(TagW.SeriesDate)));
        toolTips.append(Messages.getString("DicomSeries.date") + (date == null ? "" : date) + "<br>");
        if (this.getFileSize() > 0.0) {
            toolTips.append(Messages.getString("DicomSeries.size") + FileUtil.formatSize((double)this.getFileSize()) + "<br>");
        }
        toolTips.append("</html>");
        return toolTips.toString();
    }

    public String getMimeType() {
        String modality = (String)this.getTagValue(TagW.Modality);
        if ("PR".equals(modality)) {
            return "pr/dicom";
        }
        if ("KO".equals(modality)) {
            return "ko/dicom";
        }
        if ("SR".equals(modality)) {
            return "sr/dicom";
        }
        return "series/dicom";
    }

    public void dispose() {
        DicomSeries.stopPreloading(this);
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNearestIndex(double location) {
        List list = this.medias;
        synchronized (list) {
            int index = -1;
            double bestDiff = Double.MAX_VALUE;
            for (int i = 0; i < this.medias.size(); ++i) {
                double diff;
                double[] val = (double[])((DicomImageElement)((Object)this.medias.get(i))).getTagValue(TagW.SlicePosition);
                if (val == null || !((diff = Math.abs(location - (val[0] + val[1] + val[2]))) < bestDiff)) continue;
                bestDiff = diff;
                index = i;
            }
            return index;
        }
    }

    public static synchronized void startPreloading(DicomSeries series, int index) {
        if (series != null) {
            if (preloadingTask != null) {
                if (preloadingTask.getSeries() == series) {
                    return;
                }
                DicomSeries.stopPreloading(preloadingTask.getSeries());
            }
            preloadingTask = new PreloadingTask(series, index);
            preloadingTask.start();
        }
    }

    public static synchronized void stopPreloading(DicomSeries series) {
        if (preloadingTask != null && preloadingTask.getSeries() == series) {
            PreloadingTask moribund = preloadingTask;
            preloadingTask = null;
            if (moribund != null) {
                moribund.setPreloading(false);
                moribund.interrupt();
            }
        }
    }

    static class PreloadingTask
    extends Thread {
        private volatile boolean preloading = true;
        private final int index;
        private final ArrayList<DicomImageElement> imageList;
        private final DicomSeries series;

        public PreloadingTask(DicomSeries series, int index) {
            this.series = series;
            this.imageList = new ArrayList(series.getMedias());
            this.index = index;
        }

        public synchronized boolean isPreloading() {
            return this.preloading;
        }

        public DicomSeries getSeries() {
            return this.series;
        }

        public synchronized void setPreloading(boolean preloading) {
            this.preloading = preloading;
        }

        private void freeMemory() {
            System.gc();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private long evaluateImageSize(DicomImageElement image) {
            Integer allocated = (Integer)image.getTagValue(TagW.BitsAllocated);
            Integer sample = (Integer)image.getTagValue(TagW.SamplesPerPixel);
            Integer rows = (Integer)image.getTagValue(TagW.Rows);
            Integer columns = (Integer)image.getTagValue(TagW.Columns);
            if (allocated != null && sample != null && rows != null && columns != null) {
                return rows * columns * sample * allocated / 8;
            }
            return 0L;
        }

        private void loadArrays(DicomImageElement img, DataExplorerModel model) {
            Boolean cache;
            if (!(!this.preloading || img.isLoading() || (cache = (Boolean)img.getTagValue(TagW.ImageCache)) != null && cache.booleanValue())) {
                long start = System.currentTimeMillis();
                PlanarImage i = img.getImage();
                if (i != null) {
                    int tymin = i.getMinTileY();
                    int tymax = i.getMaxTileY();
                    int txmin = i.getMinTileX();
                    int txmax = i.getMaxTileX();
                    for (int tj = tymin; tj <= tymax; ++tj) {
                        for (int ti = txmin; ti <= txmax; ++ti) {
                            try {
                                i.getTile(ti, tj);
                                continue;
                            }
                            catch (OutOfMemoryError e) {
                                LOGGER.error("Out of memory when loading image: {}", (Object)img);
                                this.freeMemory();
                                return;
                            }
                        }
                    }
                }
                long stop = System.currentTimeMillis();
                LOGGER.debug("Reading time: {} ms of image: {}", (Object)(stop - start), (Object)img.getMediaURI());
                if (model != null) {
                    model.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Add, (Object)model, null, (Object)new SeriesEvent(SeriesEvent.Action.loadImageInMemory, (Object)this.series, (Object)img)));
                }
            }
        }

        @Override
        public void run() {
            block9: {
                if (this.imageList == null) break block9;
                DataExplorerModel model = (DataExplorerModel)this.series.getTagValue(TagW.ExplorerModel);
                int size = this.imageList.size();
                if (model == null || this.index < 0 || this.index >= size) {
                    return;
                }
                long imgSize = this.evaluateImageSize(this.imageList.get(this.index)) * (long)size + 5000L;
                long heapSize = Runtime.getRuntime().totalMemory();
                long heapFreeSize = Runtime.getRuntime().freeMemory();
                if (imgSize > heapSize / 3L) {
                    double val;
                    int ajustSize;
                    int start;
                    if (imgSize > heapFreeSize) {
                        this.freeMemory();
                    }
                    if ((start = this.index - (ajustSize = (int)((double)size * (val = (double)heapFreeSize / (double)imgSize)) / 2)) < 0) {
                        ajustSize -= start;
                        start = 0;
                    }
                    if (ajustSize > size) {
                        ajustSize = size;
                    }
                    for (int i = start; i < ajustSize; ++i) {
                        this.loadArrays(this.imageList.get(i), model);
                    }
                } else {
                    if (imgSize > heapFreeSize) {
                        this.freeMemory();
                    }
                    for (DicomImageElement img : this.imageList) {
                        this.loadArrays(img, model);
                    }
                }
            }
        }
    }
}

