/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;
import javax.media.jai.RenderedOp;
import org.weasis.core.api.image.util.Unit;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.api.media.data.MediaReader;
import org.weasis.core.api.media.data.TagW;
import org.weasis.dicom.codec.Messages;
import org.weasis.dicom.codec.geometry.GeometryOfSlice;

public class DicomImageElement
extends ImageElement {
    public DicomImageElement(MediaReader mediaIO, Object key) {
        super(mediaIO, key);
        String modality = (String)mediaIO.getTagValue(TagW.Modality);
        if (!"SC".equals(modality) && !"OT".equals(modality)) {
            double[] val = (double[])mediaIO.getTagValue(TagW.PixelSpacing);
            this.pixelSizeCalibrationDescription = val == null ? ((val = (double[])mediaIO.getTagValue(TagW.ImagerPixelSpacing)) == null ? null : Messages.getString("DicomImageElement.detector")) : (String)mediaIO.getTagValue(TagW.PixelSpacingCalibrationDescription);
            if (val != null) {
                this.pixelSizeX = val[1];
                this.pixelSizeY = val[0];
                this.pixelSpacingUnit = Unit.MILLIMETER;
            }
            this.pixelValueUnit = (String)this.getTagValue(TagW.RescaleType);
            if (this.pixelValueUnit == null) {
                this.pixelValueUnit = (String)this.getTagValue(TagW.Units);
            }
            if (this.pixelValueUnit == null && "CT".equals(modality)) {
                this.pixelValueUnit = "HU";
            }
        }
    }

    public float getPixelWindow(float window) {
        Float slope = (Float)this.getTagValue(TagW.RescaleSlope);
        if (slope != null) {
            return window /= slope.floatValue();
        }
        return window;
    }

    public float getPixelLevel(float level) {
        return this.rescale2pixel(level);
    }

    protected boolean isGrayImage(RenderedImage source) {
        Boolean val = (Boolean)this.getTagValue(TagW.MonoChrome);
        return val == null ? true : val;
    }

    public void findMinMaxValues(RenderedImage img) {
        if (this.minValue == 0.0f && this.maxValue == 0.0f) {
            Integer min = (Integer)this.getTagValue(TagW.SmallestImagePixelValue);
            Integer max = (Integer)this.getTagValue(TagW.LargestImagePixelValue);
            this.minValue = min == null ? 0.0f : min.floatValue();
            this.maxValue = max == null ? 0.0f : max.floatValue();
            Integer paddingValue = (Integer)this.getTagValue(TagW.PixelPaddingValue);
            Integer paddingLimit = (Integer)this.getTagValue(TagW.PixelPaddingRangeLimit);
            if (paddingValue != null) {
                if (paddingLimit == null) {
                    paddingLimit = paddingValue;
                } else if (paddingLimit < paddingValue) {
                    int temp = paddingValue;
                    paddingValue = paddingLimit;
                    paddingLimit = temp;
                }
                this.findMinMaxValues(img, paddingValue.intValue(), paddingLimit.intValue());
            } else if (this.minValue == 0.0f && this.maxValue == 0.0f) {
                super.findMinMaxValues(img);
            }
            this.minValue = this.pixel2rescale(this.minValue);
            this.maxValue = this.pixel2rescale(this.maxValue);
        }
    }

    public void findMinMaxValues(RenderedImage img, double paddingValueMin, double paddingValueMax) {
        if (img != null) {
            int datatype = img.getSampleModel().getDataType();
            if (datatype == 0) {
                this.minValue = 0.0f;
                this.maxValue = 255.0f;
            } else {
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(img);
                pb.add(null);
                pb.add(1);
                pb.add(1);
                pb.add(paddingValueMin);
                pb.add(paddingValueMax);
                RenderedOp dst = JAI.create((String)"ExtremaRangeLimit", (ParameterBlock)pb, null);
                ((OpImage)dst.getRendering()).setTileCache(null);
                double[][] extrema = (double[][])dst.getProperty("extrema");
                double min = Double.MAX_VALUE;
                double max = -1.7976931348623157E308;
                int numBands = dst.getSampleModel().getNumBands();
                for (int i = 0; i < numBands; ++i) {
                    min = Math.min(min, extrema[0][i]);
                    max = Math.max(max, extrema[1][i]);
                }
                this.minValue = (int)min;
                this.maxValue = (int)max;
            }
        }
    }

    public float getDefaultWindow() {
        Float val = (Float)this.getTagValue(TagW.WindowWidth);
        if (val == null) {
            return super.getDefaultWindow();
        }
        return val.floatValue();
    }

    public float getDefaultLevel() {
        Float val = (Float)this.getTagValue(TagW.WindowCenter);
        if (val == null) {
            return super.getDefaultLevel();
        }
        return val.floatValue();
    }

    public float pixel2rescale(float pixelValue) {
        Float slope = (Float)this.getTagValue(TagW.RescaleSlope);
        Float intercept = (Float)this.getTagValue(TagW.RescaleIntercept);
        if (slope != null || intercept != null) {
            return pixelValue * (slope == null ? 1.0f : slope.floatValue()) + (intercept == null ? 0.0f : intercept.floatValue());
        }
        return pixelValue;
    }

    public float rescale2pixel(float hounsfieldValue) {
        Float slope = (Float)this.getTagValue(TagW.RescaleSlope);
        Float intercept = (Float)this.getTagValue(TagW.RescaleIntercept);
        if (slope != null || intercept != null) {
            return (hounsfieldValue - (intercept == null ? 0.0f : intercept.floatValue())) / (slope == null ? 1.0f : slope.floatValue());
        }
        return hounsfieldValue;
    }

    public GeometryOfSlice getSliceGeometry() {
        double[] pos;
        double[] imgOr = (double[])this.getTagValue(TagW.ImageOrientationPatient);
        if (imgOr != null && imgOr.length == 6 && (pos = (double[])this.getTagValue(TagW.ImagePositionPatient)) != null && pos.length == 3) {
            double[] spacing = new double[]{this.getPixelSize(), this.getPixelSize(), 0.0};
            Float sliceTickness = (Float)this.getTagValue(TagW.SliceThickness);
            Integer rows = (Integer)this.getTagValue(TagW.Rows);
            Integer columns = (Integer)this.getTagValue(TagW.Columns);
            if (rows != null && columns != null && rows > 0 && columns > 0) {
                return new GeometryOfSlice(new double[]{imgOr[0], imgOr[1], imgOr[2]}, new double[]{imgOr[3], imgOr[4], imgOr[5]}, pos, spacing, sliceTickness == null ? 0.0 : sliceTickness.doubleValue(), new double[]{(double)rows.intValue() * this.getRescaleY(), (double)columns.intValue() * this.getRescaleX(), 1.0});
            }
        }
        return null;
    }
}

