/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.media;

import java.io.File;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.media.FileMetaInformation;
import org.dcm4che2.util.StringUtils;
import org.dcm4che2.util.UIDUtils;

public class FileSetInformation
extends FileMetaInformation {
    public static final int NO_KNOWN_INCONSISTENCIES = 0;
    public static final int KNOWN_INCONSISTENCIES = 65535;

    public FileSetInformation(DicomObject dcmobj) {
        super(dcmobj);
    }

    public FileSetInformation() {
    }

    public void init() {
        super.init();
        this.dcmobj.putNull(266544, VR.CS);
        this.setOffsetFirstRootRecord(0);
        this.setOffsetLastRootRecord(0);
        this.setFileSetConsistencyFlag(0);
    }

    public String getFileSetID() {
        return this.dcmobj.getString(266544);
    }

    public void setFileSetID(String id) {
        this.dcmobj.putString(266544, VR.CS, id);
    }

    public String[] getFileSetDescriptorFileID() {
        return this.dcmobj.getStrings(266561);
    }

    public void setFileSetDescriptorFileID(String[] cs) {
        this.dcmobj.putStrings(266561, VR.CS, cs);
    }

    public File getFileSetDescriptorFile(File basedir) {
        return FileSetInformation.toFile(this.getFileSetDescriptorFileID(), basedir);
    }

    public void setFileSetDescriptorFile(File file, File basedir) {
        this.setFileSetDescriptorFileID(FileSetInformation.toFileID(file, basedir));
    }

    public String getSpecificCharacterSetofFileSetDescriptorFile() {
        return this.dcmobj.getString(266562);
    }

    public void setSpecificCharacterSetofFileSetDescriptorFile(String cs) {
        this.dcmobj.putString(266544, VR.CS, cs);
    }

    public int getOffsetFirstRootRecord() {
        return this.dcmobj.getInt(266752);
    }

    public void setOffsetFirstRootRecord(int offset) {
        this.dcmobj.putInt(266752, VR.UL, offset);
    }

    public int getOffsetLastRootRecord() {
        return this.dcmobj.getInt(266754);
    }

    public void setOffsetLastRootRecord(int offset) {
        this.dcmobj.putInt(266754, VR.UL, offset);
    }

    public boolean isEmpty() {
        return this.getOffsetFirstRootRecord() == 0;
    }

    public int getFileSetConsistencyFlag() {
        return this.dcmobj.getInt(266770);
    }

    public void setFileSetConsistencyFlag(int flag) {
        this.dcmobj.putInt(266770, VR.US, flag);
    }

    public boolean isNoKnownInconsistencies() {
        return this.getFileSetConsistencyFlag() == 0;
    }

    protected String getSOPClassUID() {
        return "1.2.840.10008.1.3.10";
    }

    protected String getSOPInstanceUID() {
        return UIDUtils.createUID();
    }

    public static File toFile(String[] fileID, File basedir) {
        if (fileID == null || fileID.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(fileID[0]);
        for (int i = 1; i < fileID.length; ++i) {
            sb.append(File.separatorChar).append(fileID[i]);
        }
        return new File(basedir, sb.toString());
    }

    public static String[] toFileID(File file, File basedir) {
        String filepath = file.getPath();
        if (basedir != null) {
            String dirpath = FileSetInformation.trimDirPath(basedir.getPath()) + File.separatorChar;
            if (!filepath.startsWith(dirpath)) {
                throw new IllegalArgumentException("file " + file + " not included in file-set " + basedir);
            }
            filepath = filepath.substring(dirpath.length());
        }
        return StringUtils.split(FileSetInformation.trimFilePath(filepath), File.separatorChar);
    }

    private static String trimFilePath(String path) {
        return path.length() > 1 && path.charAt(0) == '.' && path.charAt(1) == File.separatorChar ? path.substring(2) : path;
    }

    private static String trimDirPath(String path) {
        int len = path.length();
        return len > 1 && path.charAt(len - 1) == '.' && path.charAt(len - 2) == File.separatorChar ? path.substring(0, len - 2) : path;
    }
}

