/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.dcm4che2.data.AbstractDicomElement;
import org.dcm4che2.data.DateRange;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.ElementSerializer;
import org.dcm4che2.data.SpecificCharacterSet;
import org.dcm4che2.data.VR;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SequenceDicomElement
extends AbstractDicomElement {
    private static final long serialVersionUID = 3690757302122656054L;
    private transient List<Object> items;
    private transient DicomObject parent;

    public SequenceDicomElement(int tag, VR vr, boolean bigEndian, List<Object> items, DicomObject parent) {
        super(tag, vr, bigEndian);
        if (items == null) {
            throw new NullPointerException();
        }
        this.items = items;
        this.parent = parent;
    }

    void setParentDicomObject(DicomObject parent) {
        this.parent = parent;
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            Object item = this.items.get(i);
            if (!(item instanceof DicomObject)) continue;
            ((DicomObject)item).setParent(parent);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.tag);
        s.writeShort(this.vr.code());
        s.writeBoolean(this.bigEndian);
        int size = this.items.size();
        s.writeInt(size);
        for (int i = 0; i < size; ++i) {
            Object item = this.items.get(i);
            if (item instanceof DicomObject) {
                s.writeObject(new ElementSerializer((DicomObject)item));
                continue;
            }
            s.writeObject(item);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.tag = s.readInt();
        this.vr = VR.valueOf(s.readUnsignedShort());
        this.bigEndian = s.readBoolean();
        int n = s.readInt();
        this.items = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            this.items.add(s.readObject());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SequenceDicomElement)) {
            return false;
        }
        SequenceDicomElement other = (SequenceDicomElement)o;
        return this.tag() == other.tag() && this.vr() == other.vr() && ((Object)this.items).equals(other.items);
    }

    @Override
    public DicomElement share() {
        if (this.hasDicomObjects()) {
            int n = this.items.size();
            for (int i = 0; i < n; ++i) {
                ((DicomObject)this.items.get(i)).shareElements();
            }
        }
        return this;
    }

    @Override
    protected void appendValue(StringBuffer sb, int maxValLen) {
        int size = this.items.size();
        if (size != 0) {
            if (size == 1) {
                sb.append("1 item");
            } else {
                sb.append(size).append(" items");
            }
        }
    }

    @Override
    protected void toggleEndian() {
        if (!this.hasDicomObjects()) {
            int n = this.items.size();
            for (int i = 0; i < n; ++i) {
                this.vr.toggleEndian((byte[])this.items.get(i));
            }
        }
    }

    @Override
    public final int length() {
        return this.items.isEmpty() ? 0 : -1;
    }

    @Override
    public final boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public int vm(SpecificCharacterSet cs) {
        return this.items.isEmpty() ? 0 : 1;
    }

    @Override
    public byte[] getBytes() {
        throw new UnsupportedOperationException();
    }

    public short getShort(boolean cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short[] getShorts(boolean cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(boolean cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getInts(boolean cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloat(boolean cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float[] getFloats(boolean cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(boolean cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[] getDoubles(boolean cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(SpecificCharacterSet cs, boolean cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getStrings(SpecificCharacterSet cs, boolean cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(boolean cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date[] getDates(boolean cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DateRange getDateRange(boolean cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Pattern getPattern(SpecificCharacterSet cs, boolean ignoreCase, boolean cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean hasItems() {
        return true;
    }

    @Override
    public final int countItems() {
        return this.items.size();
    }

    @Override
    public final boolean hasDicomObjects() {
        return this.vr == VR.SQ;
    }

    @Override
    public final boolean hasFragments() {
        return this.vr != VR.SQ;
    }

    @Override
    public DicomObject getDicomObject() {
        return (DicomObject)(!this.items.isEmpty() ? this.items.get(0) : null);
    }

    @Override
    public DicomObject getDicomObject(int index) {
        return (DicomObject)this.items.get(index);
    }

    @Override
    public DicomObject removeDicomObject(int index) {
        DicomObject ret = (DicomObject)this.items.remove(index);
        ret.setParent(null);
        this.updateItemPositions(index);
        return ret;
    }

    @Override
    public boolean removeDicomObject(DicomObject item) {
        if (!this.items.remove(item)) {
            return false;
        }
        item.setParent(null);
        this.updateItemPositions(item.getItemPosition() - 1);
        return true;
    }

    private void updateItemPositions(int index) {
        int n = this.countItems();
        for (int i = index; i < n; ++i) {
            this.getDicomObject(i).setItemPosition(i + 1);
        }
    }

    @Override
    public DicomObject addDicomObject(DicomObject item) {
        if (this.vr != VR.SQ) {
            throw new UnsupportedOperationException();
        }
        if (item == null) {
            throw new NullPointerException();
        }
        this.items.add(item);
        item.setParent(this.parent);
        item.setItemPosition(this.countItems());
        return item;
    }

    @Override
    public DicomObject addDicomObject(int index, DicomObject item) {
        if (this.vr != VR.SQ) {
            throw new UnsupportedOperationException();
        }
        if (item == null) {
            throw new NullPointerException();
        }
        this.items.add(index, item);
        item.setParent(this.parent);
        this.updateItemPositions(index);
        return item;
    }

    @Override
    public DicomObject setDicomObject(int index, DicomObject item) {
        if (this.vr != VR.SQ) {
            throw new UnsupportedOperationException();
        }
        if (item == null) {
            throw new NullPointerException();
        }
        this.items.set(index, item);
        item.setParent(this.parent);
        item.setItemPosition(index + 1);
        return item;
    }

    @Override
    public byte[] getFragment(int index) {
        return (byte[])this.items.get(index);
    }

    @Override
    public byte[] removeFragment(int index) {
        return (byte[])this.items.remove(index);
    }

    @Override
    public boolean removeFragment(byte[] b) {
        return this.items.remove(b);
    }

    @Override
    public byte[] addFragment(byte[] b) {
        if (this.hasDicomObjects()) {
            throw new UnsupportedOperationException();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        this.items.add(b);
        return b;
    }

    @Override
    public byte[] addFragment(int index, byte[] b) {
        if (this.hasDicomObjects()) {
            throw new UnsupportedOperationException();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        this.items.add(index, b);
        return b;
    }

    @Override
    public byte[] setFragment(int index, byte[] b) {
        if (this.hasDicomObjects()) {
            throw new UnsupportedOperationException();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        this.items.set(index, b);
        return b;
    }

    @Override
    public DicomElement filterItems(DicomObject filter) {
        if (!this.hasDicomObjects()) {
            throw new UnsupportedOperationException();
        }
        if (filter == null) {
            return this;
        }
        int count = this.countItems();
        ArrayList<Object> tmp = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            tmp.add(this.getDicomObject(i).subSet(filter));
        }
        return new SequenceDicomElement(this.tag, this.vr, this.bigEndian, tmp, this.parent);
    }

    @Override
    public String getValueAsString(SpecificCharacterSet cs, int truncate) {
        throw new UnsupportedOperationException();
    }
}

