/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.util;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.PNGEncodeParam;
import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.RenderingHints;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import org.weasis.core.api.gui.util.AbstractBufferHandler;
import org.weasis.core.api.gui.util.AbstractProperties;
import org.weasis.core.api.image.util.ImageToolkit;
import org.weasis.core.api.image.util.LayoutUtil;
import org.weasis.core.api.util.FileUtil;

public class ImageFiler
extends AbstractBufferHandler {
    public static final String[] OUTPUT_TYPE = new String[]{"Binary", "Gray Levels", "Color"};
    public static final int TILESIZE = 512;
    public static final int LIMIT_TO_TILE = 768;
    public int saveMode = 0;
    public static final int SAVE_TILED = 0;
    public static final int SAVE_MULTI = 3;
    public static final int SAVE_CANVAS = 1;
    public static final int SAVE_SVG = 4;
    public static final int OUTPUT_BINARY = 0;
    public static final int OUTPUT_GRAY = 1;
    public static final int OUTPUT_COLOR = 2;

    public ImageFiler(Component win) {
        super(win);
    }

    @Override
    protected void handleNewDocument() {
    }

    @Override
    protected boolean handleSaveDocument(OutputStream outputstream) {
        return true;
    }

    @Override
    protected boolean handleOpenDocument(InputStream inputstream) {
        return true;
    }

    public static PlanarImage getImage(String filename) {
        File f;
        RenderedOp src = null;
        if (filename != null && (f = new File(filename)).exists() && f.canRead()) {
            src = JAI.create((String)"LoadImage", (Object)f, null);
        }
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeOptimizedTIFF(File file, PlanarImage source) {
        if (file.exists() && !file.canWrite()) {
            return false;
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ImageFiler.writeOptimizedTIFF(os, source);
        }
        catch (OutOfMemoryError e) {
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                os.flush();
                ((OutputStream)os).close();
            }
            catch (IOException ex1) {}
        }
        return true;
    }

    public static PlanarImage loadImage2(InputStream stream) {
        RenderedOp src = null;
        if (stream != null) {
            try {
                FileCacheImageInputStream in = new FileCacheImageInputStream(stream, AbstractProperties.APP_TEMP_DIR);
                ImageLayout layout = new ImageLayout();
                layout.setTileWidth(512);
                layout.setTileHeight(512);
                RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
                ParameterBlockJAI pb = new ParameterBlockJAI("ImageRead");
                pb.setParameter("Input", (Object)in);
                src = JAI.create((String)"ImageRead", (ParameterBlock)pb, (RenderingHints)hints);
            }
            catch (Exception ex) {
                src = null;
            }
            if (src == null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return src;
        }
        return null;
    }

    public static boolean writeOptimizedTIFF(String fichier, PlanarImage source) throws Exception {
        return ImageFiler.writeOptimizedTIFF(new File(fichier), source);
    }

    private static void writeOptimizedTIFF(OutputStream os, PlanarImage source) throws Exception {
        TIFFEncodeParam param = new TIFFEncodeParam();
        param.setWriteTiled(true);
        param.setTileSize(512, 512);
        if (ImageUtil.isBinary((SampleModel)source.getSampleModel())) {
            param.setCompression(4);
        } else {
            param.setCompression(7);
            JPEGEncodeParam wparam = new JPEGEncodeParam();
            wparam.setQuality(1.0f);
            param.setJPEGEncodeParam(wparam);
        }
        ImageEncoder enc = ImageCodec.createImageEncoder((String)"TIFF", (OutputStream)os, (ImageEncodeParam)param);
        enc.encode((RenderedImage)source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeTIFF(File file, PlanarImage source) {
        if (file.exists() && !file.canWrite()) {
            return false;
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ImageFiler.writeTIFF(os, source);
        }
        catch (OutOfMemoryError e) {
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                os.flush();
                ((OutputStream)os).close();
            }
            catch (IOException ex1) {}
        }
        return true;
    }

    public static boolean writeTIFF(String fichier, PlanarImage source) throws Exception {
        File file = new File(fichier);
        return ImageFiler.writeTIFF(file, source);
    }

    private static void writeTIFF(OutputStream os, PlanarImage source) throws Exception {
        TIFFEncodeParam param = new TIFFEncodeParam();
        param.setWriteTiled(false);
        if (ImageUtil.isBinary((SampleModel)source.getSampleModel())) {
            param.setCompression(4);
        }
        ImageEncoder enc = ImageCodec.createImageEncoder((String)"TIFF", (OutputStream)os, (ImageEncodeParam)param);
        enc.encode((RenderedImage)source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean writePNG(File file, PlanarImage source) {
        if (file.exists() && !file.canWrite()) {
            return false;
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ImageFiler.writePNG(os, source);
        }
        catch (OutOfMemoryError e) {
            boolean bl = false;
            FileUtil.safeClose(os);
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            boolean bl = false;
            {
                catch (Throwable throwable) {
                    FileUtil.safeClose(os);
                    throw throwable;
                }
            }
            FileUtil.safeClose(os);
            return bl;
        }
        FileUtil.safeClose(os);
        return true;
    }

    public static boolean writePNG(String fichier, PlanarImage source) throws Exception {
        File file = new File(fichier);
        return ImageFiler.writePNG(file, source);
    }

    private static void writePNG(OutputStream os, PlanarImage source) throws Exception {
        PNGEncodeParam.Palette param = new PNGEncodeParam.Palette();
        ImageEncoder enc = ImageCodec.createImageEncoder((String)"PNG", (OutputStream)os, (ImageEncodeParam)param);
        enc.encode((RenderedImage)source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeJPG(File file, PlanarImage source, float quality) {
        if (file.exists() && !file.canWrite()) {
            return false;
        }
        ImageInputStream os = null;
        ImageWriter writer = null;
        try {
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("JPEG");
            if (iter.hasNext()) {
                writer = iter.next();
                os = ImageIO.createImageOutputStream(file);
                writer.setOutput(os);
                JPEGImageWriteParam iwp = new JPEGImageWriteParam(null);
                iwp.setCompressionMode(2);
                iwp.setCompressionQuality(quality);
                writer.write(null, new IIOImage((RenderedImage)source, null, null), iwp);
            }
        }
        catch (OutOfMemoryError e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (os != null) {
                    os.flush();
                    writer.dispose();
                    os.close();
                }
            }
            catch (IOException e) {}
        }
        return true;
    }

    public static boolean writeJPG(String fichier, PlanarImage source) throws Exception {
        File file = new File(fichier);
        return ImageFiler.writePNG(file, source);
    }

    public static PlanarImage getReadableImage(PlanarImage src) {
        PlanarImage dst = null;
        if (src != null && src.getSampleModel() != null) {
            ParameterBlockJAI pb;
            int numBands;
            if (ImageUtil.isBinary((SampleModel)src.getSampleModel())) {
                dst = src;
                if (src.getColorModel() instanceof IndexColorModel) {
                    IndexColorModel icm = (IndexColorModel)src.getColorModel();
                    byte[] table_data = new byte[icm.getMapSize()];
                    icm.getReds(table_data);
                    if (table_data[0] != 0) {
                        ImageLayout layout = new ImageLayout();
                        layout.setSampleModel(LayoutUtil.createBinarySampelModel(src.getTileWidth(), src.getTileHeight()));
                        layout.setColorModel(LayoutUtil.createBinaryIndexColorModel());
                        RenderingHints hints = new RenderingHints(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.FALSE);
                        hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
                        ParameterBlock pb2 = new ParameterBlock();
                        pb2.addSource(src);
                        return JAI.create((String)"NotBinary", (ParameterBlock)pb2, (RenderingHints)hints);
                    }
                }
            } else {
                dst = src.getColorModel() instanceof IndexColorModel ? PlanarImage.wrapRenderedImage((RenderedImage)ImageToolkit.convertIndexColorToRGBColor((RenderedImage)src)) : src;
            }
            if ((numBands = dst.getSampleModel().getNumBands()) == 2) {
                pb = new ParameterBlockJAI("bandSelect");
                pb.addSource((Object)dst);
                pb.setParameter("bandIndices", (Object)new int[]{0, 1, 0});
                dst = JAI.create((String)"bandSelect", (ParameterBlock)pb);
            } else if (numBands > 3) {
                pb = new ParameterBlockJAI("bandSelect");
                pb.addSource((Object)dst);
                pb.setParameter("bandIndices", (Object)new int[]{0, 1, 2});
                dst = JAI.create((String)"bandSelect", (ParameterBlock)pb);
            }
        }
        return dst;
    }

    public static String changeExtension(String filename, String ext) {
        if (filename == null) {
            return "";
        }
        int pointPos = filename.lastIndexOf(".");
        if (pointPos == -1) {
            pointPos = filename.length();
        }
        return filename.substring(0, pointPos) + ext;
    }

    public static PlanarImage getEmptyImage(Byte[] bandValues, float width, float height) {
        ParameterBlock pb = new ParameterBlock();
        pb.add(width);
        pb.add(height);
        pb.add(bandValues);
        return JAI.create((String)"constant", (ParameterBlock)pb, null);
    }

    public static PlanarImage getEmptyImage(Color color, float width, float height) {
        Byte[] bandValues = new Byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()};
        return ImageFiler.getEmptyImage(bandValues, width, height);
    }

    public static TiledImage getEmptyTiledImage(Color color, float width, float height) {
        return new TiledImage((RenderedImage)ImageFiler.getEmptyImage(color, width, height), 512, 512);
    }

    public static TiledImage getEmptyTiledImage(Byte[] bandValues, float width, float height) {
        return new TiledImage((RenderedImage)ImageFiler.getEmptyImage(bandValues, width, height), 512, 512);
    }

    public static void encodeImagePng(RenderedImage image, FileOutputStream fileStream) throws IOException {
        PNGEncodeParam.Palette param = new PNGEncodeParam.Palette();
        ImageEncoder enc = ImageCodec.createImageEncoder((String)"PNG", (OutputStream)fileStream, (ImageEncodeParam)param);
        enc.encode(image);
    }

    public static PlanarImage tileImage(PlanarImage img) {
        ImageLayout layout = new ImageLayout();
        layout.setTileWidth(512);
        layout.setTileHeight(512);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(img);
        pb.add(img.getSampleModel().getDataType());
        return JAI.create((String)"format", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

