/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.op;

import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.ComponentSampleModelJAI;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import org.weasis.core.api.image.op.RectifyUShortToShortDataOpImage;

public class RectifyUShortToShortDataDescriptor
extends OperationDescriptorImpl
implements RenderedImageFactory {
    private static final String[][] resources = new String[][]{{"GlobalName", "RectifyUShortToShortData"}, {"LocalName", "RectifyUShortToShortData"}, {"Vendor", ""}, {"Description", "Rectify image with unsigned short data to signed short data (Workaround for imageio codecs issue"}, {"DocURL", ""}, {"Version", "1.0"}};
    private static final Class[] paramClasses = new Class[0];
    private static final String[] paramNames = new String[0];
    private static final Object[] paramDefaults = new Object[0];
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public RectifyUShortToShortDataDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    public boolean validateArguments(String modeName, ParameterBlock args, StringBuffer message) {
        if (!super.validateArguments(modeName, args, message)) {
            return false;
        }
        if (!modeName.equalsIgnoreCase("rendered")) {
            return true;
        }
        RenderedImage src = args.getRenderedSource(0);
        int dtype = src.getSampleModel().getDataType();
        return dtype == 1;
    }

    @Override
    public RenderedImage create(ParameterBlock args, RenderingHints renderHints) {
        SampleModel cast;
        Object model;
        RenderedImage src = args.getRenderedSource(0);
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)renderHints);
        if (layout == null) {
            layout = new ImageLayout(src);
        }
        if ((model = src.getSampleModel()) instanceof ComponentSampleModel) {
            cast = (ComponentSampleModel)model;
            int w = cast.getWidth();
            int h = cast.getHeight();
            int pixelStride = ((ComponentSampleModel)cast).getPixelStride();
            int scanlineStride = ((ComponentSampleModel)cast).getScanlineStride();
            int[] bankIndices = ((ComponentSampleModel)cast).getBankIndices();
            int[] bandOffsets = ((ComponentSampleModel)cast).getBandOffsets();
            model = model instanceof BandedSampleModel ? new BandedSampleModel(2, w, h, scanlineStride, bankIndices, bandOffsets) : (model instanceof PixelInterleavedSampleModel ? new PixelInterleavedSampleModel(2, w, h, pixelStride, scanlineStride, bandOffsets) : (model instanceof ComponentSampleModelJAI ? new ComponentSampleModelJAI(2, w, h, pixelStride, scanlineStride, bankIndices, bandOffsets) : new ComponentSampleModel(2, w, h, pixelStride, scanlineStride, bankIndices, bandOffsets)));
        } else if (model instanceof SinglePixelPackedSampleModel) {
            cast = (SinglePixelPackedSampleModel)model;
            int scanlineStride = ((SinglePixelPackedSampleModel)cast).getScanlineStride();
            int[] bitMasks = ((SinglePixelPackedSampleModel)cast).getBitMasks();
            model = new SinglePixelPackedSampleModel(2, cast.getWidth(), cast.getHeight(), scanlineStride, bitMasks);
        }
        RenderingHints hints = new RenderingHints(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.FALSE);
        layout.setSampleModel((SampleModel)model);
        layout.setColorModel((ColorModel)new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{16}, false, false, 1, 2));
        renderHints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
        renderHints.add(hints);
        return new RectifyUShortToShortDataOpImage(args.getRenderedSource(0), renderHints, layout);
    }

    public static RenderedOp create(RenderedImage source0, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("RectifyUShortToShortData", "rendered");
        pb.setSource("source0", (Object)source0);
        return JAI.create((String)"RectifyUShortToShortData", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(RenderableImage source0, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("RectifyUShortToShortData", "renderable");
        pb.setSource("source0", (Object)source0);
        return JAI.createRenderable((String)"RectifyUShortToShortData", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

