/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.JAI;
import javax.media.jai.operator.TransposeDescriptor;
import javax.media.jai.operator.TransposeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.Messages;
import org.weasis.core.api.gui.ImageOperation;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.image.AbstractOperation;
import org.weasis.core.api.image.util.ImageToolkit;

public class RotationOperation
extends AbstractOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(RotationOperation.class);
    public static final String name = Messages.getString("RotationOperation.title");
    public static final double epsilon = 1.0E-5;

    @Override
    public RenderedImage getRenderedImage(RenderedImage source, ImageOperation imageOperation) {
        Integer rotationAngle = (Integer)imageOperation.getActionValue(ActionW.ROTATION.cmd());
        if (rotationAngle == null) {
            this.result = source;
            LOGGER.warn("Cannot apply \"{}\" because a parameter is null", (Object)name);
        } else if (rotationAngle == 0 || rotationAngle == 360) {
            this.result = source;
        } else {
            TransposeType rotOp = null;
            if ((double)Math.abs(rotationAngle - 90) < 1.0E-5) {
                rotOp = TransposeDescriptor.ROTATE_90;
            } else if ((double)Math.abs(rotationAngle - 180) < 1.0E-5) {
                rotOp = TransposeDescriptor.ROTATE_180;
            } else if ((double)Math.abs(rotationAngle - 270) < 1.0E-5) {
                rotOp = TransposeDescriptor.ROTATE_270;
            }
            if (rotOp != null) {
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(source);
                pb.add(rotOp);
                this.result = JAI.create((String)"transpose", (ParameterBlock)pb, (RenderingHints)ImageToolkit.NOCACHE_HINT);
            } else {
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(source);
                pb.add((float)source.getWidth() / 2.0f);
                pb.add((float)source.getHeight() / 2.0f);
                pb.add((float)((double)rotationAngle.intValue() * Math.PI / 180.0));
                pb.add(new InterpolationBilinear());
                this.result = JAI.create((String)"rotate", (ParameterBlock)pb, (RenderingHints)ImageToolkit.NOCACHE_HINT);
            }
        }
        return this.result;
    }

    @Override
    public String getOperationName() {
        return name;
    }
}

