/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image;

import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.List;
import org.weasis.core.api.gui.ImageOperation;
import org.weasis.core.api.image.ImageOperationAction;

public class OperationsManager {
    private final ImageOperation imageOperation;
    private final List<ImageOperationAction> operations;

    public OperationsManager(ImageOperation imageOperation) {
        if (imageOperation == null) {
            throw new IllegalArgumentException("ImageOperation cannot be null");
        }
        this.imageOperation = imageOperation;
        this.operations = new ArrayList<ImageOperationAction>();
    }

    public List<ImageOperationAction> getOperations() {
        return this.operations;
    }

    public RenderedImage getSourceImage(String name) {
        for (int i = 0; i < this.operations.size(); ++i) {
            if (!this.operations.get(i).getOperationName().equals(name)) continue;
            if (i == 0) {
                return this.imageOperation.getSourceImage();
            }
            return this.operations.get(i - 1).getRenderedImageNode();
        }
        return null;
    }

    public void addImageOperationAction(ImageOperationAction action) {
        if (action != null) {
            this.operations.add(action);
        }
    }

    public void removeAllImageOperationAction() {
        this.operations.clear();
    }

    public void clearCacheNodes() {
        for (int i = 1; i < this.operations.size(); ++i) {
            this.operations.get(i).clearNode();
        }
    }

    public RenderedImage updateAllOperations() {
        RenderedImage source = this.imageOperation.getSourceImage();
        RenderedImage result = null;
        if (source != null && this.operations.size() > 0) {
            result = this.operations.get(0).getRenderedImage(source, this.imageOperation);
            for (int i = 1; i < this.operations.size(); ++i) {
                if (result == null) {
                    return null;
                }
                result = this.operations.get(i).getRenderedImage(result, this.imageOperation);
            }
        }
        return result;
    }

    public RenderedImage updateOperation(String name) {
        RenderedImage result = null;
        int index = this.getOperationIndex(name);
        if (index == 0) {
            result = this.updateAllOperations();
        } else if (index > 0 && this.operations.size() > 0) {
            result = this.operations.get(index - 1).getRenderedImageNode();
            for (int i = index; i < this.operations.size(); ++i) {
                if (result == null) {
                    return this.updateAllOperations();
                }
                result = this.operations.get(i).getRenderedImage(result, this.imageOperation);
            }
        }
        return result;
    }

    private int getOperationIndex(String name) {
        for (int i = 0; i < this.operations.size(); ++i) {
            if (!this.operations.get(i).getOperationName().equals(name)) continue;
            return i;
        }
        return -1;
    }
}

