/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class DropDownLabel
implements Icon {
    private String label;
    private int iconWidth = 30;
    private int iconHeight = 25;

    public DropDownLabel(String label) {
        this.label = label;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(Color.black);
        this.iconHeight = g2d.getFontMetrics().getHeight() + 1;
        this.iconWidth = g2d.getFontMetrics().stringWidth(this.label) + 1;
        int baseText = g2d.getFontMetrics().getAscent();
        g2d.drawString(this.label, x, y + baseText);
        int shiftx = x + this.iconWidth + 1;
        int shifty = y + baseText - 5;
        int[] xPoints = new int[]{shiftx, shiftx + 8, shiftx + 4};
        int[] yPoints = new int[]{shifty, shifty, shifty + 4};
        g2d.fillPolygon(xPoints, yPoints, xPoints.length);
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth + 10;
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label == null ? "" : label;
    }
}

