/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.task;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JProgressBar;
import org.weasis.core.api.util.FontTools;

public class CircularProgressBar
extends JProgressBar {
    private static final Color BACK_COLOR = new Color(82, 152, 219);
    private String message;

    public CircularProgressBar() {
        this.init();
    }

    public CircularProgressBar(int min, int max) {
        super(min, max);
        this.init();
    }

    private void init() {
        this.setOpaque(false);
    }

    @Override
    public void paint(Graphics g) {
        if (g instanceof Graphics2D) {
            this.draw((Graphics2D)g);
        }
    }

    private void draw(Graphics2D g2) {
        int h = this.getHeight();
        int w = this.getWidth();
        int range = this.getMaximum() - this.getMinimum();
        if (range < 1) {
            range = 1;
        }
        int a = 360 - this.getValue() * 360 / range;
        String str = this.getValue() * 100 / range + "%";
        float x = (float)w / 2.0f - (float)g2.getFontMetrics().stringWidth(str) / 2.0f;
        float fontHeight = FontTools.getAccurateFontHeight(g2);
        float midfontHeight = fontHeight * FontTools.getMidFontHeightFactor();
        float y = (float)h / 2.0f + midfontHeight;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(Color.WHITE);
        g2.fillArc(0, 0, w, h, 0, 360);
        g2.setPaint(BACK_COLOR);
        g2.fillArc(0, 0, w, h, a, 360 - a);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        g2.setPaint(Color.BLACK);
        g2.drawString(str, x, y);
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        if (indeterminate) {
            // empty if block
        }
        super.setIndeterminate(indeterminate);
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

