/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.internal;

import org.apache.sling.commons.log.internal.LogEntryImpl;
import org.apache.sling.commons.log.internal.LogSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;

public class LogServiceFactory
implements ServiceFactory {
    private LogSupport logSupport;

    LogServiceFactory(LogSupport logSupport) {
        this.logSupport = logSupport;
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        return new LogServiceImpl(bundle);
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    private class LogServiceImpl
    implements LogService {
        private Bundle bundle;

        LogServiceImpl(Bundle bundle) {
            this.bundle = bundle;
        }

        public void log(int level, String message) {
            this.log(null, level, message, null);
        }

        public void log(int level, String message, Throwable exception) {
            this.log(null, level, message, exception);
        }

        public void log(ServiceReference sr, int level, String message) {
            this.log(sr, level, message, null);
        }

        public void log(ServiceReference sr, int level, String message, Throwable exception) {
            LogEntryImpl entry = new LogEntryImpl(this.bundle, sr, level, message, exception);
            LogServiceFactory.this.logSupport.fireLogEvent(entry);
        }
    }
}

