/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.FloatingTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindow;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.ui.MyDoggyToolWindowContainer;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.animation.AbstractAnimation;
import org.noos.xing.mydoggy.plaf.ui.animation.AnimationListener;
import org.noos.xing.mydoggy.plaf.ui.cmp.FloatingWindow;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.FloatingMoveMouseInputHandler;
import org.noos.xing.mydoggy.plaf.ui.util.DynamicPropertyChangeListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class FloatingContainer
extends MyDoggyToolWindowContainer {
    protected FloatingWindow window;
    protected FloatingMoveMouseInputHandler moveMouseInputHandler;
    protected WindowComponentAdapter windowComponentAdapter;
    protected PropertyChangeListener propertyChangeListener;
    protected AnimationListener animationListener;
    protected boolean valueAdjusting = false;
    protected Rectangle lastBounds;
    protected final FloatingAnimation floatingAnimation = new FloatingAnimation();
    protected boolean assignFocusOnAnimFinished = false;

    public FloatingContainer(ToolWindowDescriptor toolWindowDescriptor) {
        super(toolWindowDescriptor);
        this.initComponents();
        this.initListeners();
    }

    public void cleanup() {
        this.removeListeners();
        this.uninstallWindowListeners();
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean visible) {
        this.floatingAnimation.stop();
        ToolWindowPanel content = this.toolWindowPanel;
        if (visible) {
            this.window = this.descriptor.getFloatingWindow();
            this.installWindowListeners();
            this.window.addDockable(this.toolWindow, content);
            ((Component)content).setVisible(true);
            FloatingTypeDescriptor typeDescriptor = (FloatingTypeDescriptor)this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING);
            if (typeDescriptor.getSize() == null) {
                Component parentComponent = this.descriptor.getManager().getWindowAncestor();
                this.window.setSize(parentComponent.getWidth() / 2, (int)((double)parentComponent.getHeight() / 1.5));
            } else {
                this.window.setSize(typeDescriptor.getSize());
            }
            if (typeDescriptor.getLocation() == null) {
                SwingUtil.centrePositionOnScreen(this.window.getWindow());
                this.window.getWindow().setLocationRelativeTo(this.descriptor.getRepresentativeAnchor());
            } else {
                this.window.setLocation(typeDescriptor.getLocation());
            }
            SwingUtil.validateBounds(this.window.getWindow());
            if (this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING).isAnimating()) {
                this.floatingAnimation.show(new Object[0]);
            } else {
                this.window.setModal(typeDescriptor.isModal());
                this.window.getContentPane().setVisible(true);
                SwingUtil.repaint(this.window.getWindow());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!FloatingContainer.this.window.isFocused() && FloatingContainer.this.toolWindow.isActive()) {
                            FloatingContainer.this.descriptor.assignFocus();
                        }
                    }
                });
                this.window.setVisible(true);
            }
        } else {
            try {
                this.window.removeDockable(this.toolWindow);
                Object var6_5 = null;
                this.uninstallWindowListeners();
                if (this.titleBarButtons.getFocusable().isFocusable()) {
                    this.titleBarButtons.getFocusable().setFocusable(false);
                }
                this.lastBounds = this.window.getBounds();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.uninstallWindowListeners();
                if (this.titleBarButtons.getFocusable().isFocusable()) {
                    this.titleBarButtons.getFocusable().setFocusable(false);
                }
                this.lastBounds = this.window.getBounds();
                if (this.window.getDockableCount() <= 0) {
                    this.window.getContentPane().setVisible(true);
                    this.window.setVisible(false);
                    this.descriptor.removeFloatingWindow();
                }
                this.window = null;
                throw throwable;
            }
            if (this.window.getDockableCount() <= 0) {
                this.window.getContentPane().setVisible(true);
                this.window.setVisible(false);
                this.descriptor.removeFloatingWindow();
            }
            this.window = null;
            {
            }
        }
    }

    public void setVisible(ToolWindowDescriptor referenceAggregationTool, Component content, ToolWindowDescriptor aggregationOnTool, AggregationPosition aggregationPosition) {
        this.window = ((FloatingContainer)referenceAggregationTool.getToolWindowContainer(ToolWindowType.FLOATING)).getWindow();
        this.window.addDockable(this.toolWindow, content, aggregationOnTool != null ? aggregationOnTool.getToolWindow() : null, aggregationPosition);
        this.installWindowListeners();
        if (!this.window.isVisible()) {
            if (this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING).isAnimating()) {
                this.floatingAnimation.show(new Object[0]);
            } else {
                FloatingTypeDescriptor typeDescriptor = (FloatingTypeDescriptor)this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING);
                this.window.setModal(typeDescriptor.isModal());
                this.window.setVisible(true);
                this.window.getContentPane().setVisible(true);
                SwingUtil.repaint(this.window.getWindow());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!FloatingContainer.this.window.isFocused() && FloatingContainer.this.toolWindow.isActive()) {
                            FloatingContainer.this.descriptor.assignFocus();
                        }
                    }
                });
            }
        }
    }

    public FloatingWindow getWindow() {
        return this.window;
    }

    public boolean isAnimating() {
        return this.floatingAnimation.isAnimating();
    }

    protected void initComponents() {
    }

    protected void initListeners() {
        this.propertyChangeListener = new PropertyListener();
        MyDoggyToolWindow toolWindowSource = this.descriptor.getToolWindow();
        toolWindowSource.addPlafPropertyChangeListener(this.propertyChangeListener, "type", "maximized");
        PropertyChangeEventSource floatingTypeDescriptorSource = (PropertyChangeEventSource)((Object)this.descriptor.getToolWindow().getTypeDescriptor(FloatingTypeDescriptor.class));
        floatingTypeDescriptorSource.addPlafPropertyChangeListener(this.propertyChangeListener);
        this.animationListener = new AnimationListener(){

            public void onFinished() {
                if (FloatingContainer.this.assignFocusOnAnimFinished) {
                    FloatingContainer.this.descriptor.assignFocus();
                    FloatingContainer.this.assignFocusOnAnimFinished = false;
                }
            }
        };
        this.floatingAnimation.addAnimationListener(this.animationListener);
        this.moveMouseInputHandler = new FloatingMoveMouseInputHandler(null);
        this.windowComponentAdapter = new WindowComponentAdapter();
    }

    protected void removeListeners() {
        MyDoggyToolWindow toolWindowSource = this.descriptor.getToolWindow();
        toolWindowSource.removePlafPropertyChangeListener(this.propertyChangeListener, "type", "maximized");
        PropertyChangeEventSource floatingTypeDescriptorSource = (PropertyChangeEventSource)((Object)this.descriptor.getToolWindow().getTypeDescriptor(FloatingTypeDescriptor.class));
        floatingTypeDescriptorSource.removePlafPropertyChangeListener(this.propertyChangeListener);
        this.floatingAnimation.removeAnimationListener(this.animationListener);
        this.moveMouseInputHandler = new FloatingMoveMouseInputHandler(null);
        this.windowComponentAdapter = new WindowComponentAdapter();
    }

    protected void reinitWindow(FloatingWindow oldWindow) {
        this.window = this.descriptor.getFloatingWindow();
        this.window.importFrom(oldWindow);
        this.installWindowListeners();
    }

    protected void installWindowListeners() {
        this.moveMouseInputHandler.setFloatingContainer(this.window.getWindow());
        this.toolWindowTabPanel.addEventDispatcherlListener(this.moveMouseInputHandler);
        this.toolWindowTitleBar.addMouseMotionListener(this.moveMouseInputHandler);
        this.toolWindowTitleBar.addMouseListener(this.moveMouseInputHandler);
        this.window.getWindow().addComponentListener(this.windowComponentAdapter);
    }

    protected void uninstallWindowListeners() {
        this.moveMouseInputHandler.setFloatingContainer(null);
        if (this.window != null) {
            this.window.getWindow().removeComponentListener(this.windowComponentAdapter);
        }
        this.toolWindowTabPanel.removeEventDispatcherlListener(this.moveMouseInputHandler);
        this.toolWindowTitleBar.removeMouseMotionListener(this.moveMouseInputHandler);
        this.toolWindowTitleBar.removeMouseListener(this.moveMouseInputHandler);
    }

    public class PropertyListener
    extends DynamicPropertyChangeListener {
        public void onMaximized(PropertyChangeEvent evt) {
            if (FloatingContainer.this.toolWindow.getType() == ToolWindowType.FLOATING || FloatingContainer.this.toolWindow.getType() == ToolWindowType.FLOATING_FREE) {
                if (((Boolean)evt.getNewValue()).booleanValue()) {
                    SwingUtil.setFullScreen(FloatingContainer.this.window.getWindow());
                } else {
                    SwingUtil.restoreFullScreenWindow(FloatingContainer.this.window.getWindow());
                }
                SwingUtil.repaint(FloatingContainer.this.window.getWindow());
            }
        }

        public void onEnabled(PropertyChangeEvent evt) {
            boolean newValue = (Boolean)evt.getNewValue();
            if (!newValue && FloatingContainer.this.toolWindow.getType() == ToolWindowType.FLOATING) {
                FloatingContainer.this.toolWindow.setType(ToolWindowType.DOCKED);
            }
        }

        public void onSize(PropertyChangeEvent evt) {
            if (FloatingContainer.this.window == null) {
                return;
            }
            if (FloatingContainer.this.valueAdjusting) {
                return;
            }
            if (FloatingContainer.this.window.isVisible()) {
                Dimension size = (Dimension)evt.getNewValue();
                FloatingContainer.this.window.setSize(size);
            }
            FloatingContainer.this.lastBounds = null;
        }

        public void onLocation(PropertyChangeEvent evt) {
            if (FloatingContainer.this.window == null) {
                return;
            }
            if (FloatingContainer.this.valueAdjusting) {
                return;
            }
            if (FloatingContainer.this.window.isVisible()) {
                Point location = (Point)evt.getNewValue();
                FloatingContainer.this.window.setLocation(location);
            }
            FloatingContainer.this.lastBounds = null;
        }

        public void onModal(PropertyChangeEvent evt) {
            if (FloatingContainer.this.window == null) {
                return;
            }
            if (FloatingContainer.this.window.isVisible()) {
                FloatingContainer.this.window.dispose();
                FloatingContainer.this.window.setModal((Boolean)evt.getNewValue());
                FloatingContainer.this.window.setVisible(true);
            }
        }

        public void onAddToTaskBar(PropertyChangeEvent evt) {
            if (FloatingContainer.this.window == null) {
                return;
            }
            if (FloatingContainer.this.window.isVisible()) {
                FloatingWindow oldWindow = FloatingContainer.this.window;
                FloatingContainer.this.uninstallWindowListeners();
                FloatingContainer.this.descriptor.removeFloatingWindow();
                Component focusOwner = oldWindow.getWindow().getFocusOwner();
                oldWindow.setVisible(false);
                FloatingContainer.this.reinitWindow(oldWindow);
                oldWindow.getWindow().dispose();
                FloatingContainer.this.window.setVisible(true);
                if (focusOwner != null) {
                    SwingUtil.requestFocus(focusOwner);
                }
            } else {
                FloatingWindow oldWindow = FloatingContainer.this.window;
                FloatingContainer.this.uninstallWindowListeners();
                FloatingContainer.this.descriptor.removeFloatingWindow();
                oldWindow.getWindow().dispose();
            }
        }

        public void onOsDecorated(PropertyChangeEvent evt) {
            if (FloatingContainer.this.window == null) {
                return;
            }
            FloatingContainer.this.window.dispose();
            FloatingContainer.this.window.setUndecorated((Boolean)evt.getNewValue() == false);
            FloatingContainer.this.window.setVisible(true);
        }

        public void onAlwaysOnTop(PropertyChangeEvent evt) {
            if (FloatingContainer.this.window == null) {
                return;
            }
            if (FloatingContainer.this.window.isVisible()) {
                FloatingWindow oldWindow = FloatingContainer.this.window;
                FloatingContainer.this.uninstallWindowListeners();
                FloatingContainer.this.descriptor.removeFloatingWindow();
                Component focusOwner = oldWindow.getWindow().getFocusOwner();
                oldWindow.setVisible(false);
                FloatingContainer.this.reinitWindow(oldWindow);
                oldWindow.getWindow().dispose();
                FloatingContainer.this.window.setVisible(true);
                if (focusOwner != null) {
                    SwingUtil.requestFocus(focusOwner);
                }
            } else {
                FloatingWindow oldWindow = FloatingContainer.this.window;
                FloatingContainer.this.uninstallWindowListeners();
                FloatingContainer.this.descriptor.removeFloatingWindow();
                oldWindow.getWindow().dispose();
            }
        }

        public void onResizable(PropertyChangeEvent evt) {
            if (FloatingContainer.this.toolWindow.getType() == ToolWindowType.FLOATING || FloatingContainer.this.toolWindow.getType() == ToolWindowType.FLOATING_FREE && FloatingContainer.this.window != null) {
                FloatingContainer.this.window.setResizable((Boolean)evt.getNewValue());
            }
        }
    }

    public class WindowComponentAdapter
    extends ComponentAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentResized(ComponentEvent e) {
            FloatingContainer.this.valueAdjusting = true;
            try {
                ((FloatingTypeDescriptor)FloatingContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING)).setSize(FloatingContainer.this.window.getWidth(), FloatingContainer.this.window.getHeight());
            }
            finally {
                FloatingContainer.this.valueAdjusting = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentMoved(ComponentEvent e) {
            FloatingContainer.this.valueAdjusting = true;
            try {
                ((FloatingTypeDescriptor)FloatingContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING)).setLocation(FloatingContainer.this.window.getX(), FloatingContainer.this.window.getY());
            }
            finally {
                FloatingContainer.this.valueAdjusting = false;
            }
        }
    }

    public class FloatingAnimation
    extends AbstractAnimation {
        protected Rectangle originalBounds;
        protected int lastLenX;
        protected int lastLenY;

        public FloatingAnimation() {
            super(80.0f);
            this.lastLenX = 0;
            this.lastLenY = 0;
        }

        protected float onAnimating(float animationPercent) {
            int animatingLengthX = (int)(animationPercent * (float)this.originalBounds.width);
            int animatingLengthY = (int)(animationPercent * (float)this.originalBounds.height);
            if (this.getAnimationDirection() == AbstractAnimation.Direction.INCOMING) {
                FloatingContainer.this.window.setBounds(FloatingContainer.this.window.getX() - (animatingLengthX / 2 - this.lastLenX / 2), FloatingContainer.this.window.getY() - (animatingLengthY / 2 - this.lastLenY / 2), FloatingContainer.this.window.getWidth() + (animatingLengthX - this.lastLenX), FloatingContainer.this.window.getHeight() + (animatingLengthY - this.lastLenY));
            } else {
                FloatingContainer.this.window.setBounds(FloatingContainer.this.window.getX() + (animatingLengthX / 2 - this.lastLenX / 2), FloatingContainer.this.window.getY() + (animatingLengthY / 2 - this.lastLenY / 2), FloatingContainer.this.window.getWidth() - (animatingLengthX - this.lastLenX), FloatingContainer.this.window.getHeight() - (animatingLengthY - this.lastLenY));
            }
            this.lastLenX = animatingLengthX;
            this.lastLenY = animatingLengthY;
            return animationPercent;
        }

        protected void onFinishAnimation() {
            switch (this.getAnimationDirection()) {
                case INCOMING: {
                    FloatingContainer.this.window.getContentPane().setVisible(true);
                    FloatingContainer.this.window.setBounds(this.originalBounds);
                    SwingUtil.repaint(FloatingContainer.this.window.getWindow());
                    if (FloatingContainer.this.window.isFocused() || !FloatingContainer.this.toolWindow.isActive()) break;
                    FloatingContainer.this.descriptor.assignFocus();
                    break;
                }
                case OUTGOING: {
                    FloatingContainer.this.window.getContentPane().setVisible(true);
                    FloatingContainer.this.window.setVisible(false);
                    FloatingContainer.this.window.setBounds(this.originalBounds);
                }
            }
        }

        protected void onHide(Object ... params) {
            this.originalBounds = FloatingContainer.this.window.getBounds();
            FloatingContainer.this.window.getContentPane().setVisible(false);
        }

        protected void onShow(Object ... params) {
            this.originalBounds = FloatingContainer.this.window.getBounds();
            FloatingContainer.this.window.setBounds(new Rectangle(this.originalBounds.x + this.originalBounds.width / 2, this.originalBounds.y + this.originalBounds.height / 2, 0, 0));
            FloatingTypeDescriptor typeDescriptor = (FloatingTypeDescriptor)FloatingContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING);
            FloatingContainer.this.window.setModal(typeDescriptor.isModal());
            FloatingContainer.this.window.setVisible(true);
        }

        protected void onStartAnimation(AbstractAnimation.Direction direction) {
            this.lastLenX = 0;
            this.lastLenY = 0;
        }

        protected AbstractAnimation.Direction chooseFinishDirection(AbstractAnimation.Type type) {
            return type == AbstractAnimation.Type.SHOW ? AbstractAnimation.Direction.OUTGOING : AbstractAnimation.Direction.INCOMING;
        }
    }
}

