/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.weasis.core.api.gui.util.JMVUtils;
import org.weasis.core.api.gui.util.WinUtil;
import org.weasis.core.ui.docking.UIManager;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.editor.image.ImageViewerEventManager;
import org.weasis.core.ui.editor.image.ImageViewerPlugin;
import org.weasis.core.ui.editor.image.MeasureToolBar;
import org.weasis.core.ui.editor.image.ViewerPlugin;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.util.ViewSetting;

public class PaintLabel
extends JDialog {
    public static final String[] fontSize = new String[]{"8", "9", "10", "11", "12", "13", "14", "15", "16"};
    private JPanel panel1 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanelChangeCanal = new JPanel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JButton jButtonApply = new JButton();
    private JPanel jPanel2 = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel jLabelFont = new JLabel();
    private JComboBox jComboName = new JComboBox();
    private JLabel jLabelSize = new JLabel();
    private JComboBox jComboSize = new JComboBox<String>(fontSize);
    private JButton jButtonClose = new JButton();
    private JCheckBox jCheckBoxBold = new JCheckBox();
    private JCheckBox jCheckBoxItalic = new JCheckBox();
    private ImageViewerEventManager eventManager;

    public PaintLabel(ImageViewerEventManager eventManager) {
        super(WinUtil.getParentDialogOrFrame(eventManager.getSelectedView2dContainer()), "Default Graphic Properties", Dialog.ModalityType.APPLICATION_MODAL);
        this.eventManager = eventManager;
        this.enableEvents(64L);
        try {
            JMVUtils.setList((JComboBox)this.jComboName, (Object)"Default", (Object[])GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
            this.jbInit();
            this.initialize();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.jPanelChangeCanal.setLayout(this.gridBagLayout2);
        this.jButtonApply.setText("Apply");
        this.jButtonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaintLabel.this.apply();
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaintLabel.this.closeWin();
            }
        });
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanelChangeCanal, "South");
        this.jPanelChangeCanal.add((Component)this.jButtonApply, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 0, new Insets(25, 25, 10, 15), 0, 0));
        this.panel1.add((Component)this.jPanel2, "West");
        this.jPanel2.setLayout(this.gridBagLayout1);
        this.jLabelFont.setText("Name:");
        this.jLabelSize.setText("Size:");
        this.jPanel2.setBorder(new TitledBorder("Font (Global)"));
        this.jCheckBoxBold.setText("Bold");
        this.jCheckBoxItalic.setText("Italic");
        this.jPanel2.add((Component)this.jComboSize, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 5, 0), 0, 0));
        this.jPanel2.add((Component)this.jLabelFont, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jComboName, new GridBagConstraints(2, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 5), 0, 0));
        this.jPanel2.add((Component)this.jCheckBoxItalic, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.jPanel2.add((Component)this.jCheckBoxBold, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.jPanel2.add((Component)this.jLabelSize, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.jPanelChangeCanal.add((Component)this.jButtonClose, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 0, new Insets(25, 15, 10, 20), 0, 0));
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.closeWin();
        }
        super.processWindowEvent(e);
    }

    private void closeWin() {
        this.dispose();
    }

    private void initialize() {
        ViewSetting setting = this.eventManager.getViewSetting();
        int style = setting.getFontType();
        if (style == 3) {
            this.jCheckBoxBold.setSelected(true);
            this.jCheckBoxItalic.setSelected(true);
        } else if (style == 1) {
            this.jCheckBoxBold.setSelected(true);
        } else if (style == 2) {
            style = 2;
            this.jCheckBoxItalic.setSelected(true);
        }
        String size = String.valueOf(setting.getFontSize());
        int index = 2;
        for (int i = 0; i < fontSize.length; ++i) {
            if (!fontSize[i].equals(size)) continue;
            index = i;
            break;
        }
        this.jComboSize.setSelectedIndex(index);
        this.jComboName.setSelectedItem(setting.getFontName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() {
        int size = Integer.parseInt(this.jComboSize.getSelectedItem().toString());
        int style = 0;
        if (this.jCheckBoxBold.isSelected() && this.jCheckBoxItalic.isSelected()) {
            style = 3;
        } else if (this.jCheckBoxBold.isSelected()) {
            style = 1;
        } else if (this.jCheckBoxItalic.isSelected()) {
            style = 2;
        }
        String name = this.jComboName.getSelectedItem().toString();
        ViewSetting setting = this.eventManager.getViewSetting();
        setting.setFontName(name);
        setting.setFontSize(size);
        setting.setFontType(style);
        ArrayList<Graphic> graphicList = MeasureToolBar.graphicList;
        for (int i = 1; i < graphicList.size(); ++i) {
            MeasureToolBar.applyDefaultSetting(setting, graphicList.get(i));
        }
        List<ViewerPlugin> list = UIManager.VIEWER_PLUGINS;
        synchronized (list) {
            for (int i = UIManager.VIEWER_PLUGINS.size() - 1; i >= 0; --i) {
                ViewerPlugin p = UIManager.VIEWER_PLUGINS.get(i);
                if (!(p instanceof ImageViewerPlugin)) continue;
                for (DefaultView2d v : ((ImageViewerPlugin)p).getImagePanels()) {
                    if (!(v instanceof DefaultView2d)) continue;
                    DefaultView2d view = v;
                    List<Graphic> list2 = view.getLayerModel().getdAllGraphics();
                    for (Graphic graphic : list2) {
                        graphic.updateLabel(view.getImage(), view);
                    }
                }
            }
        }
    }
}

