/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic.model;

import java.util.ArrayList;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.graphic.model.AbstractLayer;

public enum Tools {
    CROSSLINES(0, Messages.getString("Tools.cross"), true, ""),
    NOTE(1, Messages.getString("Tools.Anno"), true, "note_pinned.png"),
    MEASURE(2, Messages.getString("Tools.meas"), true, "measure1D.png"),
    OBJECTEXTRACT(4, Messages.getString("Tools.seg"), true, "objectExtract.png"),
    CALIBRATION(8, Messages.getString("Tools.calib"), false, "calibration.png"),
    INFOLAYER(12, "", true, ""),
    TEMPCLASSIFLAYER(10, "", true, ""),
    TEMPDRAGLAYER(11, Messages.getString("Tools.deco"), true, "");

    private final int id;
    private final String title;
    private final boolean layer;
    private final String imgName;

    private Tools(int id, String title, boolean islayer, String imgName) {
        this.id = id;
        this.title = title;
        this.layer = islayer;
        this.imgName = imgName;
    }

    public int getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String toString() {
        return this.title;
    }

    public boolean isLayer() {
        return this.layer;
    }

    public String getImgName() {
        return this.imgName;
    }

    public static Tools getCurrentTools(int toolPosition) {
        for (Tools t : Tools.values()) {
            if (toolPosition != t.ordinal()) continue;
            return t;
        }
        return TEMPDRAGLAYER;
    }

    public static void setLevelToLayers(ArrayList<AbstractLayer> layers) {
        if (layers != null) {
            block9: for (int j = layers.size() - 1; j >= 0; --j) {
                AbstractLayer layer = layers.get(j);
                switch (layer.getDrawType()) {
                    case 0: {
                        layer.setLevel(0);
                        continue block9;
                    }
                    case 1: {
                        layer.setLevel(1);
                        continue block9;
                    }
                    case 2: {
                        layer.setLevel(2);
                        continue block9;
                    }
                    case 3: {
                        layer.setLevel(3);
                        continue block9;
                    }
                    case 4: {
                        layer.setLevel(4);
                        continue block9;
                    }
                    case 10: {
                        layer.setLevel(10);
                        continue block9;
                    }
                    case 11: {
                        layer.setLevel(11);
                        continue block9;
                    }
                    default: {
                        layer.setLevel(12);
                    }
                }
            }
        }
    }

    public static String getToolName(int id) {
        for (Tools t : Tools.values()) {
            if (id != t.id) continue;
            return t.title;
        }
        return "";
    }

    public static final ArrayList<String> getToolsName() {
        ArrayList<String> list = new ArrayList<String>();
        for (Tools t : Tools.values()) {
            if (t.equals((Object)TEMPDRAGLAYER) || t.equals((Object)TEMPCLASSIFLAYER)) continue;
            list.add(t.getTitle());
        }
        return list;
    }

    public static final ArrayList<Tools> getToolsToDisplay() {
        ArrayList<Tools> list = new ArrayList<Tools>();
        for (Tools t : Tools.values()) {
            if (t.equals((Object)TEMPDRAGLAYER) || t.equals((Object)TEMPCLASSIFLAYER)) continue;
            list.add(t);
        }
        return list;
    }
}

